#include "gameplay/classes/classes_spell_slots.h"
#include "engine/core/handler.h"
#include "gameplay/magic/spells_info.h"
#include "engine/db/global_objects.h"

//    
void DoSpellCapable(CharData *ch, char *argument, int/* cmd*/, int/* subcmd*/) {

	using classes::CalcCircleSlotsAmount;

	struct TimedFeat timed;

	if (!IS_IMPL(ch) && (ch->IsNpc() || !CanUseFeat(ch, EFeat::kSpellCapabler))) {
		SendMsgToChar("   .\r\n", ch);
		return;
	}

	if (IsTimedByFeat(ch, EFeat::kSpellCapabler) && !IS_IMPL(ch)) {
		SendMsgToChar("    .\r\n", ch);
		return;
	}

	char *s;
	if (ch->IsNpc() && AFF_FLAGGED(ch, EAffect::kCharmed))
		return;

	if (AFF_FLAGGED(ch, EAffect::kSilence)) {
		SendMsgToChar("     .\r\n", ch);
		return;
	}

	if (!*argument) {
		SendMsgToChar("   ?\r\n", ch);
		return;
	}
	s = strtok(argument, "'*!");
	if (!str_cmp(s, argument)) {
		SendMsgToChar("       : '  *  !\r\n", ch);
		return;
	}

	auto spell_id = FixNameAndFindSpellId(s);
	if (spell_id == ESpell::kUndefined) {
		SendMsgToChar("     ?\r\n", ch);
		return;
	}

	const auto spell = MUD::Class(ch->GetClass()).spells[spell_id];
	if ((!IS_SET(GET_SPELL_TYPE(ch, spell_id), ESpellType::kTemp | ESpellType::kKnow) ||
		GetRealRemort(ch) < spell.GetMinRemort()) &&
		(GetRealLevel(ch) < kLvlGreatGod) && (!ch->IsNpc())) {
		if (GetRealLevel(ch) < CalcMinSpellLvl(ch, spell_id) ||
			CalcCircleSlotsAmount(ch, spell.GetCircle()) <= 0) {
			SendMsgToChar("     !\r\n", ch);
			return;
		} else {
			SendMsgToChar("   ,  ,  ...\r\n", ch);
			return;
		}
	}

	if (!GET_SPELL_MEM(ch, spell_id) && !IS_IMMORTAL(ch)) {
		SendMsgToChar("   ,    ...\r\n", ch);
		return;
	}

	FollowerType *k;
	CharData *follower = nullptr;
	for (k = ch->followers; k; k = k->next) {
		if (AFF_FLAGGED(k->follower, EAffect::kCharmed)
			&& k->follower->get_master() == ch
			&& k->follower->IsFlagged(EMobFlag::kClone)
			&& !IsAffectedBySpell(k->follower, ESpell::kCapable)
			&& ch->isInSameRoom(k->follower)) {
			follower = k->follower;
			break;
		}
	}
	if (!GET_SPELL_MEM(ch, spell_id) && !IS_IMMORTAL(ch)) {
		SendMsgToChar("   ,    ...\r\n", ch);
		return;
	}

	if (!follower) {
		SendMsgToChar("      .\r\n", ch);
		return;
	}

	act("   $N3.", false, ch, nullptr, follower, kToChar);
	act("$n $u  -   -    $N3.", false, ch, nullptr, follower, kToRoom);

	GET_SPELL_MEM(ch, spell_id)--;
	if (!ch->IsNpc() && !IS_IMMORTAL(ch) && ch->IsFlagged(EPrf::kAutomem))
		MemQ_remember(ch, spell_id);

	if (!MUD::Spell(spell_id).IsViolent() ||
		!MUD::Spell(spell_id).IsFlagged(kMagDamage) ||
		MUD::Spell(spell_id).IsFlagged(kMagMasses) ||
		MUD::Spell(spell_id).IsFlagged(kMagGroups) ||
		MUD::Spell(spell_id).IsFlagged(kMagAreas)) {
		SendMsgToChar("  ,    .\r\n", ch);
		return;
	}
	// - ...        ? .
	//RemoveAffectFromChar(ch, to_underlying(EFeat::kSpellCapabler));

	timed.feat = EFeat::kSpellCapabler;

	switch (MUD::Class(ch->GetClass()).spells[spell_id].GetCircle()) {
		case 1:
		case 2:
		case 3:
		case 4:
		case 5://1-5   4 
			timed.time = 4;
			break;
		case 6:
		case 7://6-7   6 
			timed.time = 6;
			break;
		case 8://8   10 
			timed.time = 10;
			break;
		case 9://9   12 
			timed.time = 12;
			break;
		default://10   
			timed.time = 24;
	}
	ImposeTimedFeat(ch, &timed);

	GET_CAST_SUCCESS(follower) = GetRealRemort(ch) * 4;
	Affect<EApply> af;
	af.type = ESpell::kCapable;
	af.duration = 48;
	if (GetRealRemort(ch) > 0) {
		af.modifier = GetRealRemort(ch) * 4;//    +*4 
		af.location = EApply::kCastSuccess;
	} else {
		af.modifier = 0;
		af.location = EApply::kNone;
	}
	af.battleflag = 0;
	af.bitvector = 0;
	affect_to_char(follower, af);
	follower->mob_specials.capable_spell = spell_id;
}

// vim: ts=4 sw=4 tw=0 noet syntax=cpp :
