#include "ironwind.h"

#include "gameplay/fight/pk.h"
#include "gameplay/fight/common.h"
#include "gameplay/fight/fight_hit.h"
#include "parry.h"
#include "engine/core/handler.h"

void go_iron_wind(CharData *ch, CharData *victim) {
	if (IsUnableToAct(ch)) {
		SendMsgToChar("     .\r\n", ch);
		return;
	}
	if (ch->GetPosition() < EPosition::kFight) {
		SendMsgToChar("    .\r\n", ch);
		return;
	}
	if (ch->IsFlagged(EPrf::kIronWind)) {
		SendMsgToChar("    .\r\n", ch);
		return;
	}
	if (ch->GetEnemy() && (ch->GetEnemy() != victim)) {
		act("$N    ,   $S.", false, ch, nullptr, victim, kToChar);
		return;
	}

	CheckParryOverride(ch);

	act("   ,     $N3!\r\n", false, ch, nullptr, victim, kToChar);
	ObjData *weapon;
	if ((weapon = GET_EQ(ch, EEquipPos::kWield)) || (weapon = GET_EQ(ch, EEquipPos::kBoths))) {
		strcpy(buf, "$n $g  $u  $N3,   $o4!");
		strcpy(buf2, "$N $G  $U  ,   $o4!");
	} else {
		strcpy(buf, "$n  $g  $u  $N3!");
		strcpy(buf2, "$N  $G  $U  !");
	};
	act(buf, false, ch, weapon, victim, kToNotVict | kToArenaListen);
	act(buf2, false, victim, weapon, ch, kToChar);

	if (!ch->GetEnemy()) {
		ch->SetFlag(EPrf::kIronWind);
		ch->battle_affects.set(kEafIronWind);
		hit(ch, victim, ESkill::kUndefined, fight::kMainHand);
		SetWait(ch, 2, true);
		//ch->setSkillCooldown(ESkill::kGlobalCooldown, 2);
		//ch->setSkillCooldown(ESkill::kIronwind, 2);
	} else {
		ch->SetFlag(EPrf::kIronWind);
		ch->battle_affects.set(kEafIronWind);
	}
}

void do_iron_wind(CharData *ch, char *argument, int/* cmd*/, int/* subcmd*/) {
	if (ch->IsNpc() || !ch->GetSkill(ESkill::kIronwind)) {
		SendMsgToChar("   .\r\n", ch);
		return;
	};
	if (ch->HasCooldown(ESkill::kIronwind)) {
		SendMsgToChar("   .\r\n", ch);
		return;
	};
	if (ch->battle_affects.get(kEafOverwhelm) || ch->battle_affects.get(kEafHammer)) {
		SendMsgToChar("!    !\r\n", ch);
		return;
	};
	int moves = ch->get_max_move() / (2 + std::max(15, ch->GetSkill(ESkill::kIronwind)) / 15);
	if (ch->get_max_move() < moves * 2) {
		SendMsgToChar("  ...\r\n", ch);
		return;
	}

	CharData *vict = FindVictim(ch, argument);
	if (!vict) {
		SendMsgToChar("     ?\r\n", ch);
		return;
	}

	if (vict == ch) {
		SendMsgToChar("       ... .\r\n", ch);
		return;
	}

	if (!may_kill_here(ch, vict, argument)) {
		return;
	}
	if (!check_pkill(ch, vict, arg)) {
		return;
	}

	go_iron_wind(ch, vict);
}

void ProcessIronWindHits(CharData *ch, fight::AttackType weapon) {
	int percent = 0, prob = 0, div = 0, moves = 0;
	/*
	     100%
	       80%+ ,      80% 
	      ,      80% 
	       170%+ ,      30% 
	*/
	if (ch->IsFlagged(EPrf::kIronWind)) {
		percent = ch->GetSkill(ESkill::kIronwind);
		moves = ch->get_max_move() / (6 + std::max(10, percent) / 10);
		prob = ch->battle_affects.get(kEafIronWind);
		if (prob && !check_moves(ch, moves)) {
			ch->battle_affects.unset(kEafIronWind);
		} else if (!prob && (ch->get_move() > moves)) {
			ch->battle_affects.set(kEafIronWind);
		};
	};
	if (ch->battle_affects.get(kEafIronWind)) {
		TrainSkill(ch, ESkill::kIronwind, true, ch->GetEnemy());
		if (weapon == fight::kMainHand) {
			div = 100 + std::min(80, std::max(1, percent - 80));
			prob = 100;
		} else {
			div = std::min(80, percent + 10);
			prob = 80 - std::min(30, std::max(0, percent - 170));
		};
		while (div > 0) {
			if (number(1, 100) < div)
				hit(ch, ch->GetEnemy(), ESkill::kUndefined, weapon);
			div -= prob;
		};
	};
}

// vim: ts=4 sw=4 tw=0 noet syntax=cpp
