#include "engine/entities/char_data.h"
#include "engine/core/handler.h"
#include "engine/db/global_objects.h"
#include "gameplay/fight/fight.h"

void DoFirstaid(CharData *ch, char *argument, int/* cmd*/, int/* subcmd*/) {
	struct TimedSkill timed;

	if (!ch->GetSkill(ESkill::kFirstAid)) {
		SendMsgToChar("   .\r\n", ch);
		return;
	}
	if (!IS_GOD(ch) && IsTimedBySkill(ch, ESkill::kFirstAid)) {
		SendMsgToChar("    -   .\r\n", ch);
		return;
	}

	one_argument(argument, arg);

	CharData *vict;
	if (!*arg) {
		vict = ch;
	} else {
		vict = get_char_vis(ch, arg, EFind::kCharInRoom);
		if (!vict) {
			SendMsgToChar("   ?\r\n", ch);
			return;
		}
	}

	if (vict->GetEnemy()) {
		act("$N , $M     .", false, ch, nullptr, vict, kToChar);
		return;
	}
	if (vict->IsNpc() && !IS_CHARMICE(vict)) {
		SendMsgToChar("    -   .\r\n", ch);
		return;
	}
	int percent = number(1, MUD::Skills()[ESkill::kFirstAid].difficulty);
	int prob = CalcCurrentSkill(ch, ESkill::kFirstAid, vict);
	if (IS_IMMORTAL(ch) || GET_GOD_FLAG(ch, EGf::kGodsLike) || GET_GOD_FLAG(vict, EGf::kGodsLike)) {
		percent = 0;
	}
	if (GET_GOD_FLAG(ch, EGf::kGodscurse) || GET_GOD_FLAG(vict, EGf::kGodscurse)) {
		prob = 0;
	}
	auto success = (prob >= percent);
	bool need = false;
	bool enough_skill = false;
	if ((vict->get_real_max_hit() > 0 && (vict->get_hit() * 100 / vict->get_real_max_hit()) < 31) ||
		(vict->get_real_max_hit() <= 0 && vict->get_hit() < vict->get_real_max_hit()) ||
		(vict->get_hit() < vict->get_real_max_hit() && CanUseFeat(ch, EFeat::kHealer))) {
		need = true;
		enough_skill = true;
		if (success) {
			int dif = std::min(vict->get_real_max_hit(), vict->get_real_max_hit() - vict->get_hit());
			int add = std::min(dif, (dif * (prob - percent) / 100) + 1);
			vict->set_hit(vict->get_hit() + add);
		}
	}
	auto spell_id{ESpell::kUndefined};
	for (int count = MAX_FIRSTAID_REMOVE - 1; count >= 0; count--) {
		spell_id = GetRemovableSpellId(count);
		if (IsAffectedBySpell(vict, spell_id)) {
			need = true;
			if (prob / 10  > count) {
				enough_skill = true;
				break;
			}
		}
	}
	if (!need) {
		act("$N    .", false, ch, nullptr, vict, kToChar);
	} else if (!enough_skill) {
		act("      $N3.", false, ch, nullptr, vict, kToChar);
	} else {
		timed.skill = ESkill::kFirstAid;
		int time = IS_IMMORTAL(ch) ? 1 : IS_PALADINE(ch) ? 4 : IS_SORCERER(ch) ? 2 : 6;
		if (CanUseFeat(ch, EFeat::kPhysicians))
			time /=2;
		timed.time = time;
		ImposeTimedSkill(ch, &timed);
		ImproveSkill(ch, ESkill::kFirstAid, success, nullptr);
		if (vict != ch) {
			if (success) {
				act("    $N2.", false, ch, nullptr, vict, kToChar);
				act("$n $g   $N2.",
					true, ch, nullptr, vict, kToNotVict | kToArenaListen);
				if (spell_id != ESpell::kUndefined) {
					RemoveAffectFromCharAndRecalculate(vict, spell_id);
				}
				if (ch->get_sex() == EGender::kMale)
					sprintf(buf, "%s    .\r\n", ch->get_name().c_str());
				else 
					sprintf(buf, "%s    .\r\n", ch->get_name().c_str());
				SendMsgToChar(buf, vict);
				if (vict->get_wait() > 0)
					vict->set_wait(0);
				update_pos(vict);
			} else {
				act("      $N2.",
					false, ch, nullptr, vict, kToChar);
				act("$N  $U    .",
					false, vict, nullptr, ch, kToChar);
				act("$n  $u    $N2.",
					true, ch, nullptr, vict, kToNotVict | kToArenaListen);
			}
		} else {
			if (success) {
				act("    .",
					false, ch, nullptr, nullptr, kToChar);
				act("$n $g   .",
					false, ch, nullptr, nullptr, kToRoom | kToArenaListen);
				if (spell_id != ESpell::kUndefined) {
					RemoveAffectFromCharAndRecalculate(vict, spell_id);
				}
			} else {
				act("      .",
					false, ch, nullptr, vict, kToChar);
				act("$n  $u    .",
					false, ch, nullptr, vict, kToRoom | kToArenaListen);
			}
		}
	}
}

// vim: ts=4 sw=4 tw=0 noet syntax=cpp :
