#include "gameplay/fight/pk.h"
#include "gameplay/fight/common.h"
#include "gameplay/fight/fight.h"
#include "protect.h"
#include "engine/db/global_objects.h"
#include "dazzle.h"
#include "engine/core/action_targeting.h"
#include "engine/core/handler.h"

//
// Created by Svetodar on 04.01.2024.
//
void DoDazzle(CharData *ch, char *argument, int/* cmd*/, int/* subcmd*/) {
	if (!IS_IMMORTAL(ch) && IsUnableToAct(ch)) {
		SendMsgToChar("     .\r\n", ch);
		return;
	}
	if (!ch->GetSkill(ESkill::kDazzle)) {
		SendMsgToChar("   .\r\n", ch);
		return;
	}
	if (!IS_IMMORTAL(ch) && ch->HasCooldown(ESkill::kDazzle)) {
		SendMsgToChar("   .\r\n", ch);
		return;
	}
	if (ch->IsOnHorse()) {
		SendMsgToChar("   .\r\n", ch);
		return;
	}
	if (ch->GetPosition() < EPosition::kFight) {
		SendMsgToChar("    .\r\n", ch);
		return;
	}
	if (!ch->GetEnemy()) {
		SendMsgToChar("     !  -?   ...\r\n", ch);
		return;
	}
	CharData *vict = FindVictim(ch, argument);

	if (!vict) {
		SendMsgToChar("       ?\r\n", ch);
		return;
	}
	if (vict == ch) {
		SendMsgToChar("    ,   !\r\n", ch);
		return;
	}
	if (!IS_IMMORTAL(ch) && IsAffectedBySpellWithCasterId(vict, ch, ESpell::kDazzle)) {
		SendMsgToChar("   !\r\n", ch);
		return;
	}
	GoDazzle(ch, vict);
}


void GoDazzle(CharData *ch, CharData *vict) {
	if (IsUnableToAct(ch)) {
		SendMsgToChar("     .\r\n", ch);
		return;
	}

	if (ch == vict) {
		SendMsgToChar("    ,   !\r\n", ch);
		return;
	}

	if (ch->GetPosition() < EPosition::kFight) {
		SendMsgToChar("    .\r\n", ch);
		return;
	}
	bool has_pepper = false;

	for (auto i = ch->carrying;i; i = i->get_next_content()) {
		if (i->get_type() == EObjType::kWand && GET_OBJ_VAL(i,3) == 356 && GET_OBJ_VAL(i,2) > 0) {
			int charges = GET_OBJ_VAL(i,2);
			if (charges > 0) {
				i->set_val(2, charges - 1);
				has_pepper = true;
				break;
			}
		}
	}

	if (!IS_IMMORTAL(ch) && !has_pepper) {
		SendMsgToChar("&W    ?!       !\r\n&n", ch);
		return;
	}

	int victims_amount = 3;
	if (ch->GetSkill(ESkill::kDazzle) > 200) {
		victims_amount = 4;
	};

	Affect<EApply> af;
	af.type = ESpell::kBlindness;
	af.battleflag = kAfPulsedec;
	af.duration = 150 + (ch->GetSkill(ESkill::kDazzle) * 1.25);
	af.bitvector = to_underlying(EAffect::kBlind);

	Affect<EApply> af2;
	af2.type = ESpell::kDazzle;
	af2.duration = 5;
	af2.battleflag = kNone;
	af2.caster_id = ch->get_uid();

	ActionTargeting::FoesRosterType roster{ch};
	for (const auto target: roster) {
		if (!IsAffectedBySpellWithCasterId(ch, target, ESpell::kDazzle)) {
			if (!IS_IMMORTAL(ch) && !target->IsNpc()) {
				SendMsgToChar("  !    ...\r\n", ch);
				continue;
			} else {
				if (target != ch && target->GetEnemy() == ch) {
					SkillRollResult result = MakeSkillTest(ch, ESkill::kDazzle,target);
					bool success = result.success;

					TrainSkill(ch, ESkill::kDazzle, success,target);
					TryToFindProtector(target, ch);
					if (success) {
						affect_to_char(target, af);
						affect_to_char(target, af2);
						act("&Y   ,       $N1!  $E    !&n",
							false, ch, nullptr,target, kToChar);
						act("$N $G    -  ! ,  ֣ !",
							false,target, nullptr, ch, kToChar);
						act("  \"   ?!\", $N $G $n2    - !",
							false,target, nullptr, ch, kToNotVict | kToArenaListen);
						if (ch->GetEnemy() != target) {
							stop_fighting(target, false);
						}
					} else {
						act("&W    $N3.    $E  $G  !&n",
							false, ch, nullptr,target, kToChar);
						act("$N $U   - ,        .  !",
							false,target, nullptr, ch, kToChar);
						act("$N $U  $n3 - ,     $G .",
							false,target, nullptr, ch, kToNotVict | kToArenaListen);
					}
				}
			}
		} else {
			act("&W  - $N   $G,      !&n",
				false, ch, nullptr, vict, kToChar);
		}
		--victims_amount;
		if (victims_amount <= 0) {
				break;
		}
	}
	if (!IS_IMMORTAL(ch)) {
		SetSkillCooldownInFight(ch, ESkill::kDazzle, 2);
	}
}
