//      
//
#include "mount.h"

#include "engine/entities/char_data.h"
#include "engine/entities/entities_constants.h"
#include "engine/core/handler.h"

void make_horse(CharData *horse, CharData *ch) {
	AFF_FLAGS(horse).set(EAffect::kHorse);
	ch->add_follower(horse);
	horse->UnsetFlag(EMobFlag::kWimpy);
	horse->UnsetFlag(EMobFlag::kSentinel);
	horse->UnsetFlag(EMobFlag::kHelper);
	horse->UnsetFlag(EMobFlag::kAgressive);
	horse->UnsetFlag(EMobFlag::kMounting);
	AFF_FLAGS(horse).unset(EAffect::kTethered);
}

void do_horseon(CharData *ch, char *argument, int/* cmd*/, int/* subcmd*/) {
	CharData *horse;

	if (ch->IsNpc())
		return;

	if (!ch->get_horse()) {
		SendMsgToChar("   .\r\n", ch);
		return;
	}

	if (ch->IsOnHorse()) {
		SendMsgToChar("     .\r\n", ch);
		return;
	}

	one_argument(argument, arg);
	if (*arg)
		horse = get_char_vis(ch, arg, EFind::kCharInRoom);
	else
		horse = ch->get_horse();

	if (horse == nullptr)
		SendMsgToChar(NOPERSON, ch);
	else if (horse->in_room != ch->in_room)
		SendMsgToChar("    .\r\n", ch);
	else if (!IS_HORSE(horse))
		SendMsgToChar("  .\r\n", ch);
	else if (horse->get_master() != ch)
		SendMsgToChar("   .\r\n", ch);
	else if (horse->GetPosition() < EPosition::kFight)
		act("$N       .", false, ch, 0, horse, kToChar);
	else if (AFF_FLAGGED(horse, EAffect::kTethered))
		act("   $N3.", false, ch, 0, horse, kToChar);
		//    
	else if (ROOM_FLAGGED(ch->in_room, ERoomFlag::kTunnel))
		SendMsgToChar("  .\r\n", ch);
	else if (ROOM_FLAGGED(ch->in_room, ERoomFlag::kNohorse))
		act("$Z $N $G  $U  .", false, ch, 0, horse, kToChar);
	else {
		if (IsAffectedBySpell(ch, ESpell::kSneak))
			RemoveAffectFromCharAndRecalculate(ch, ESpell::kSneak);
		if (IsAffectedBySpell(ch, ESpell::kCamouflage))
			RemoveAffectFromCharAndRecalculate(ch, ESpell::kCamouflage);
		act("    $N1.", false, ch, 0, horse, kToChar);
		act("$n $g  $N3.", false, ch, 0, horse, kToRoom | kToArenaListen);
		AFF_FLAGS(ch).set(EAffect::kHorse);
	}
}

void do_horseoff(CharData *ch, char * /*argument*/, int/* cmd*/, int/* subcmd*/) {
	CharData *horse;

	if (ch->IsNpc())
		return;
	if (!(horse = ch->get_horse())) {
		SendMsgToChar("   .\r\n", ch);
		return;
	}

	if (!ch->IsOnHorse()) {
		SendMsgToChar("      .\r\n", ch);
		return;
	}
	ch->dismount();

}

void do_horseget(CharData *ch, char *argument, int/* cmd*/, int/* subcmd*/) {
	CharData *horse;

	if (ch->IsNpc())
		return;

	if (!ch->get_horse()) {
		SendMsgToChar("   .\r\n", ch);
		return;
	}

	if (ch->IsOnHorse()) {
		SendMsgToChar("    .\r\n", ch);
		return;
	}

	one_argument(argument, arg);
	if (*arg)
		horse = get_char_vis(ch, arg, EFind::kCharInRoom);
	else
		horse = ch->get_horse();

	if (horse == nullptr)
		SendMsgToChar(NOPERSON, ch);
	else if (horse->in_room != ch->in_room)
		SendMsgToChar("    .\r\n", ch);
	else if (!IS_HORSE(horse))
		SendMsgToChar("  .\r\n", ch);
	else if (horse->get_master() != ch)
		SendMsgToChar("   .\r\n", ch);
	else if (!AFF_FLAGGED(horse, EAffect::kTethered))
		act(" $N   $A.", false, ch, 0, horse, kToChar);
	else {
		act("  $N3.", false, ch, 0, horse, kToChar);
		act("$n $g $N3.", false, ch, 0, horse, kToRoom | kToArenaListen);
		AFF_FLAGS(horse).unset(EAffect::kTethered);
	}
}

void do_horseput(CharData *ch, char *argument, int/* cmd*/, int/* subcmd*/) {
	CharData *horse;

	if (ch->IsNpc())
		return;
	if (!ch->get_horse()) {
		SendMsgToChar("   .\r\n", ch);
		return;
	}

	if (ch->IsOnHorse()) {
		SendMsgToChar("    .\r\n", ch);
		return;
	}

	one_argument(argument, arg);
	if (*arg)
		horse = get_char_vis(ch, arg, EFind::kCharInRoom);
	else
		horse = ch->get_horse();
	if (horse == nullptr)
		SendMsgToChar(NOPERSON, ch);
	else if (horse->in_room != ch->in_room)
		SendMsgToChar("    .\r\n", ch);
	else if (!IS_HORSE(horse))
		SendMsgToChar("  .\r\n", ch);
	else if (horse->get_master() != ch)
		SendMsgToChar("   .\r\n", ch);
	else if (AFF_FLAGGED(horse, EAffect::kTethered))
		act(" $N    $A.", false, ch, 0, horse, kToChar);
	else {
		act("  $N3.", false, ch, 0, horse, kToChar);
		act("$n $g $N3.", false, ch, 0, horse, kToRoom | kToArenaListen);
		AFF_FLAGS(horse).set(EAffect::kTethered);
	}
}

void do_horsetake(CharData *ch, char *argument, int/* cmd*/, int/* subcmd*/) {
	CharData *horse = nullptr;

	if (ch->IsNpc())
		return;

	if (ch->get_horse()) {
		SendMsgToChar("   ?\r\n", ch);
		return;
	}

	one_argument(argument, arg);
	if (*arg) {
		horse = get_char_vis(ch, arg, EFind::kCharInRoom);
	}

	if (horse == nullptr) {
		SendMsgToChar(NOPERSON, ch);
		return;
	} else if (!horse->IsNpc()) {
		SendMsgToChar(",  ...\r\n", ch);
		return;
	}
		//      . --  (13.10.10)
	else if (!IS_GOD(ch)
		&& !horse->IsFlagged(EMobFlag::kMounting)
		&& !(horse->has_master()
			&& AFF_FLAGGED(horse, EAffect::kHorse))) {
		act("    $N3.", false, ch, 0, horse, kToChar);
		return;
	} else if (ch->get_horse()) {
		if (ch->get_horse() == horse)
			act("   $S  .", false, ch, 0, horse, kToChar);
		else
			SendMsgToChar("      .\r\n", ch);
		return;
	} else if (horse->GetPosition() < EPosition::kStand) {
		act("$N     .", false, ch, 0, horse, kToChar);
		return;
	} else if (IS_HORSE(horse)) {
		if (!IS_IMMORTAL(ch)) {
			SendMsgToChar("   .\r\n", ch);
			return;
		}
	}
	if (stop_follower(horse, kSfEmpty))
		return;
	act("  $N3.", false, ch, 0, horse, kToChar);
	act("$n $g $N3.", false, ch, 0, horse, kToRoom | kToArenaListen);
	make_horse(horse, ch);
}

void do_givehorse(CharData *ch, char *argument, int/* cmd*/, int/* subcmd*/) {
	CharData *horse, *victim;

	if (ch->IsNpc())
		return;

	if (!(horse = ch->get_horse())) {
		SendMsgToChar("    .\r\n", ch);
		return;
	}
	if (!ch->has_horse(true)) {
		SendMsgToChar("    .\r\n", ch);
		return;
	}
	one_argument(argument, arg);
	if (!*arg) {
		SendMsgToChar("    ?\r\n", ch);
		return;
	}
	if (!(victim = get_char_vis(ch, arg, EFind::kCharInRoom))) {
		SendMsgToChar("   .\r\n", ch);
		return;
	} else if (victim->IsNpc()) {
		SendMsgToChar("    .\r\n", ch);
		return;
	}
	if (victim->get_horse()) {
		act(" $N1   .\r\n", false, ch, 0, victim, kToChar);
		return;
	}
	if (ch->IsOnHorse()) {
		SendMsgToChar("    .\r\n", ch);
		return;
	}
	if (AFF_FLAGGED(horse, EAffect::kTethered)) {
		SendMsgToChar("     .\r\n", ch);
		return;
	}
	//               -- Krodo
	if (stop_follower(horse, kSfEmpty))
		return;
	act("    $N2.", false, ch, 0, victim, kToChar);
	act("$n $g   .", false, ch, 0, victim, kToVict);
	act("$n $g   $N2.", true, ch, 0, victim, kToNotVict | kToArenaListen);
	make_horse(horse, victim);
}

void do_stophorse(CharData *ch, char * /*argument*/, int/* cmd*/, int/* subcmd*/) {
	CharData *horse;

	if (ch->IsNpc())
		return;

	if (!(horse = ch->get_horse())) {
		SendMsgToChar("    .\r\n", ch);
		return;
	}
	if (!ch->has_horse(true)) {
		SendMsgToChar("    .\r\n", ch);
		return;
	}
	if (ch->IsOnHorse()) {
		SendMsgToChar("    .\r\n", ch);
		return;
	}
	if (AFF_FLAGGED(horse, EAffect::kTethered)) {
		SendMsgToChar("     .\r\n", ch);
		return;
	}
	if (stop_follower(horse, kSfEmpty))
		return;
	act("  $N3.", false, ch, 0, horse, kToChar);
	act("$n $g $N3.", false, ch, 0, horse, kToRoom | kToArenaListen);
	if (GET_MOB_VNUM(horse) == kHorseVnum) {
		act("$n $g   .\r\n", false, horse, 0, 0, kToRoom | kToArenaListen);
		ExtractCharFromWorld(horse, false);
	}
}