/**
\file illumination.cpp - a part of the Bylins engine.
\authors Created by Sventovit.
\date 19.09.2024.
\brief / .
\detail ,            .
*/

#include "gameplay/mechanics/illumination.h"

#include "utils/utils.h"
#include "gameplay/magic/magic_rooms.h"
#include "engine/db/db.h"
#include "engine/entities/char_data.h"

extern bool IsWearingLight(CharData *ch);

bool is_dark(RoomRnum room) {
	double coef = 0.0;

	//       ,  
	// +2  
	if (room_spells::IsRoomAffected(world[room], ESpell::kLight))
		coef += 2.0;
	//      !  !
	if ((SECT(room) != ESector::kInside) && (SECT(room) != ESector::kCity)
		&& (GET_ROOM_SKY(room) == kSkyLightning
			&& weather_info.moon_day >= kFullMoonStart
			&& weather_info.moon_day <= kFullMoonStop))
		coef += 1.0;

	//          
	if ((SECT(room) != ESector::kInside) && (SECT(room) != ESector::kCity)
		&& ((weather_info.sunlight == kSunSet) || (weather_info.sunlight == kSunDark)))
		coef -= 1.0;
	//     
	if (ROOM_FLAGGED(room, ERoomFlag::kDarked))
		coef -= 1.0;

	if (ROOM_FLAGGED(room, ERoomFlag::kAlwaysLit))
		coef += 200.0;

	//   
	if (world[room]->fires)
		coef += 1.0;

	//          //

	for (const auto tmp_ch : world[room]->people) {
		//     , ,   
		if (IsWearingLight(tmp_ch))
			coef += 1.0;
		//     
		if (AFF_FLAGGED(tmp_ch, EAffect::kSingleLight))
			coef += 3.0;
		//   1 !
		if (AFF_FLAGGED(tmp_ch, EAffect::kHolyLight))
			coef += 9.0;
		// . ,      ,      
		if (AFF_FLAGGED(tmp_ch, EAffect::kSanctuary))
			coef += 1.0;
		// .    6.
		if (AFF_FLAGGED(tmp_ch, EAffect::kHolyDark))
			coef -= 6.0;
	}

	if (coef < 0) {
		return true;
	}
	return false;

}

bool IsDefaultDark(RoomRnum room_rnum) {
	return (ROOM_FLAGGED(room_rnum, ERoomFlag::kDarked) ||
		(SECT(room_rnum) != ESector::kInside &&
			SECT(room_rnum) != ESector::kCity &&
			(weather_info.sunlight == kSunSet ||
				weather_info.sunlight == kSunDark)));
}

// vim: ts=4 sw=4 tw=0 noet syntax=cpp :
