//
// Created by Sventovit on 03.09.2024.
//

#ifndef BYLINS_SRC_GAME_MECHANICS_DEAD_LOAD_H_
#define BYLINS_SRC_GAME_MECHANICS_DEAD_LOAD_H_

#include "engine/structs/structs.h"

#include <list>

namespace dead_load {

enum EDeadLoadType {
	kOrdinary		= 0,	//  
	kProgression	= 1,	//    0.01,    ,    MiW
	kSkin			= 2		//   
};

enum EDeadLoadCmdType {
	kAnyway = 0,					//  .
	kPreviuosSuccess = 1,			//      .
  	kAnywaySaveState = 2,			//  ,     .
  	kPreviuosSuccessSaveState = 3	//     ,   .
};

// ===============================================================
// Structure used for on_dead object loading //
//    .
struct LoadingItem {
  ObjVnum obj_vnum{0};
  int load_prob{0};
  int load_type{0};
  int spec_param{0};
};

using OnDeadLoadList = std::list<struct LoadingItem>;

bool ParseDeadLoadLine(OnDeadLoadList &dl_list, char *line);
bool LoadObjFromDeadLoad(ObjData *corpse, CharData *ch, CharData *chr, EDeadLoadType load_type);
int ResolveTagsInObjName(ObjData *obj, CharData *ch);
} // namespace dead_load

#endif //BYLINS_SRC_GAME_MECHANICS_DEAD_LOAD_H_


