// Copyright (c) 2016 bodrich
// Part of Bylins http://www.bylins.su
#pragma once

#include "bonus_types.h"

#include <string>

class CharData;    // to avoid inclusion of "char.hpp"

namespace Bonus {
//      (    )    
//   -   false
bool can_get_bonus_exp(CharData *ch);

void setup_bonus(int duration_in_seconds, int multilpier, EBonusType type);

void do_bonus_by_character(CharData *ch, char *argument, int cmd, int subcmd);
void do_bonus_info(CharData *ch, char *argument, int cmd, int subcmd);

//     
bool is_bonus_active(EBonusType type);

//     
bool is_bonus_active();

void timer_bonus();

//      
std::string time_to_bonus_end_as_string();

//    .    -  
std::string active_bonus_as_string();

int get_mult_bonus();
void bonus_log_load();
void show_log(CharData *ch);
void dg_do_bonus(char *cmd);
}
