#include "magic_items.h"

#include "engine/entities/char_data.h"
#include "engine/core/handler.h"
#include "engine/db/obj_prototypes.h"
#include "spells_info.h"
#include "magic_utils.h"
#include "engine/db/global_objects.h"

const short kDefaultStaffLvl = 12;
const short kDefaultWandLvl = 12;

extern char cast_argument[kMaxInputLength];

void EmployMagicItem(CharData *ch, ObjData *obj, const char *argument) {
	int i;
	int level;
	CharData *tch = nullptr;
	ObjData *tobj = nullptr;
	RoomData *troom = nullptr;

	one_argument(argument, cast_argument);
	level = GET_OBJ_VAL(obj, 0) * -1;
	if (level == 0) {
		if (obj->get_type() == EObjType::kStaff) {
			level = kDefaultStaffLvl;
		} else if (obj->get_type() == EObjType::kWand) {
			level = kDefaultWandLvl;
		}
	}

	if (obj->has_flag(EObjFlag::kTimedLvl)) {
		int proto_timer = obj_proto[obj->get_rnum()]->get_timer();
		if (proto_timer != 0) {
			level -= level * (proto_timer - obj->get_timer()) / proto_timer;
		}
	}

	auto spell_id = static_cast<ESpell>(GET_OBJ_VAL(obj, 3));
	switch (obj->get_type()) {
		case EObjType::kStaff:
			if (!obj->get_action_description().empty()) {
				act(obj->get_action_description().c_str(), false, ch, obj, nullptr, kToChar);
				act(obj->get_action_description().c_str(), false, ch, obj, nullptr, kToRoom | kToArenaListen);
			} else {
				act("  $o4  .", false, ch, obj, nullptr, kToChar);
				act("$n $g $o4  .", false, ch, obj, nullptr, kToRoom | kToArenaListen);
			}

			if (GET_OBJ_VAL(obj, 2) <= 0) {
				SendMsgToChar(",   :)\r\n", ch);
				act("   .", false, ch, obj, nullptr, kToRoom | kToArenaListen);
			} else {
				obj->dec_val(2);
				SetWaitState(ch, kBattleRound);
				if (MUD::Spell(spell_id).IsFlagged(kMagMasses | kMagAreas)) {
					CallMagic(ch, nullptr, nullptr, world[ch->in_room], spell_id, level);
				} else  if (MUD::Spell(spell_id).IsFlagged(kMagGroups | kMagManual | kMagCharRelocate)) {
					CallMagic(ch, ch, nullptr, world[ch->in_room], spell_id, level);
				} else {
					const auto people_copy = world[ch->in_room]->people;
					for (const auto target : people_copy) {
						if (ch != target) {
							CallMagic(ch, target, nullptr, world[ch->in_room], spell_id, level);
						}
					}
				}
			}
			break;

		case EObjType::kWand:
			if (GET_OBJ_VAL(obj, 2) <= 0) {
				SendMsgToChar(",  .\r\n", ch);
				return;
			}

			if (!*argument) {
				if (!MUD::Spell(spell_id).IsFlagged(kMagAreas | kMagMasses)) {
					tch = ch;
				}
			} else {
				if (!FindCastTarget(spell_id, argument, ch, &tch, &tobj, &troom)) {
					return;
				}
			}

			if (tch) {
				if (tch == ch) {
					if (!obj->get_action_description().empty()) {
						act(obj->get_action_description().c_str(), false, ch, obj, tch, kToChar);
						act(obj->get_action_description().c_str(), false, ch, obj, tch, kToRoom | kToArenaListen);
					} else {
						act("  $o4  .", false, ch, obj, nullptr, kToChar);
						act("$n $g $o4  .", false, ch, obj, nullptr, kToRoom | kToArenaListen);
					}
				} else {
					if (!obj->get_action_description().empty()) {
						act(obj->get_action_description().c_str(), false, ch, obj, tch, kToChar);
						act(obj->get_action_description().c_str(), false, ch, obj, tch, kToRoom | kToArenaListen);
					} else {
						act("  $o4  $N3.", false, ch, obj, tch, kToChar);
						act("$N $G $o4  .", false, tch, obj, ch, kToChar);
						act("$n $g $o4  $N3.", true, ch, obj, tch, kToNotVict | kToArenaListen);
					}
				}
			} else if (tobj) {
				if (!obj->get_action_description().empty()) {
					act(obj->get_action_description().c_str(), false, ch, obj, tobj, kToChar);
					act(obj->get_action_description().c_str(), false, ch, obj, tobj, kToRoom | kToArenaListen);
				} else {
					act("  $o4  $O2.", false, ch, obj, tobj, kToChar);
					act("$n $u $o4  $O2.", true, ch, obj, tobj, kToRoom | kToArenaListen);
				}
			} else {
				if (!obj->get_action_description().empty()) {
					act(obj->get_action_description().c_str(), false, ch, obj, tch, kToChar);
					act(obj->get_action_description().c_str(), false, ch, obj, tch, kToRoom | kToArenaListen);
				} else {
					act("  $o4  .", false, ch, obj, nullptr, kToChar);
					act("$n $g $o4  .", true, ch, obj, nullptr, kToRoom | kToArenaListen);
				}
			}

			obj->dec_val(2);
			SetWaitState(ch, kBattleRound);
			CallMagic(ch, tch, tobj, world[ch->in_room], spell_id, level);
			break;

		case EObjType::kScroll:
			if (AFF_FLAGGED(ch, EAffect::kSilence)) {
				SendMsgToChar(" ,  .\r\n", ch);
				return;
			}
			if (AFF_FLAGGED(ch, EAffect::kBlind)) {
				SendMsgToChar(" .\r\n", ch);
				return;
			}

			spell_id = static_cast<ESpell>(GET_OBJ_VAL(obj, 1));
			if (!*argument) {
				for (int slot = 1; slot < 4; slot++) {
					if (MUD::Spell(static_cast<ESpell>(GET_OBJ_VAL(obj, slot))).IsFlagged(kMagAreas | kMagMasses)) {
						break;
					}
					tch = ch;
				}
			} else if (!FindCastTarget(spell_id, argument, ch, &tch, &tobj, &troom)) {
				return;
			}

			if (!obj->get_action_description().empty()) {
				act(obj->get_action_description().c_str(), false, ch, obj, nullptr, kToChar);
				act(obj->get_action_description().c_str(), false, ch, obj, nullptr, kToRoom | kToArenaListen);
			} else {
				act("  $o3, $W   .", true, ch, obj, nullptr, kToChar);
				act("$n $g $o3.", false, ch, obj, nullptr, kToRoom | kToArenaListen);
			}

			SetWaitState(ch, kBattleRound);
			for (i = 1; i <= 3; i++) {
				if (CallMagic(ch, tch, tobj, world[ch->in_room], static_cast<ESpell>(GET_OBJ_VAL(obj, i)), level) <= 0) {
					break;
				}
			}

			/*if (obj != nullptr) {
				extract_obj(obj);
			}*/
			ExtractObjFromWorld(obj);
			break;

		case EObjType::kPotion:
			if (AFF_FLAGGED(ch, EAffect::kStrangled) && AFF_FLAGGED(ch, EAffect::kSilence)) {
				SendMsgToChar("       !\r\n", ch);
				return;
			}
			tch = ch;
			if (!obj->get_action_description().empty()) {
				act(obj->get_action_description().c_str(), true, ch, obj, nullptr, kToChar);
				act(obj->get_action_description().c_str(), false, ch, obj, nullptr, kToRoom | kToArenaListen);
			} else {
				act("  $o3.", false, ch, obj, nullptr, kToChar);
				act("$n $g $o3.", true, ch, obj, nullptr, kToRoom | kToArenaListen);
			}

			SetWaitState(ch, kBattleRound);
			for (i = 1; i <= 3; i++) {
				if (CallMagic(ch, ch, nullptr, world[ch->in_room], static_cast<ESpell>(GET_OBJ_VAL(obj, i)), level) <= 0) {
					break;
				}
			}

			/*if (obj != nullptr) {
				extract_obj(obj);
			}*/
			ExtractObjFromWorld(obj);
			break;

		default: log("SYSERR: Unknown object_type %d in EmployMagicItem.", obj->get_type());
			break;
	}
}

// vim: ts=4 sw=4 tw=0 noet syntax=cpp :
