// Part of Bylins http://www.mud.ru

#include <random>

#include "gameplay/affects/affect_data.h"
#include "gameplay/mechanics/dead_load.h"
#include "gameplay/mechanics/dungeons.h"
#include "gameplay/ai/mobact.h"
#include "engine/entities/obj_data.h"
#include "engine/ui/cmd/do_flee.h"
#include "engine/db/world_characters.h"
#include "fight.h"
#include "fight_penalties.h"
#include "fight_hit.h"
#include "engine/core/handler.h"
#include "gameplay/mechanics/corpse.h"
#include "gameplay/clans/house.h"
#include "pk.h"
#include "gameplay/mechanics/stuff.h"
#include "gameplay/statistics/top.h"
#include "engine/ui/color.h"
#include "gameplay/statistics/mob_stat.h"
#include "gameplay/mechanics/bonus.h"
#include "utils/backtrace.h"
#include "gameplay/magic/magic_utils.h"
#include "engine/entities/char_player.h"
#include "engine/core/utils_char_obj.inl"
#include "gameplay/mechanics/sight.h"
#include "gameplay/ai/mob_memory.h"
#include "engine/entities/zone.h"
#include "gameplay/core/game_limits.h"
#include "gameplay/mechanics/illumination.h"
#include "utils/utils_time.h"
#include "gameplay/skills/leadership.h"

// extern
void PerformDropGold(CharData *ch, int amount);
int max_exp_gain_pc(CharData *ch);
int max_exp_loss_pc(CharData *ch);
void get_from_container(CharData *ch, ObjData *cont, char *local_arg, int mode, int amount, bool autoloot);
void SetWait(CharData *ch, int waittime, int victim_in_room);

extern int max_exp_gain_npc;
extern std::list<combat_list_element> combat_list;

//       
void process_mobmax(CharData *ch, CharData *killer) {
	bool leader_partner = false;
	int partner_feat = 0;
	int total_group_members = 1;
	CharData *partner = nullptr;

	CharData *master = nullptr;
	if (killer->IsNpc()
		&& (AFF_FLAGGED(killer, EAffect::kCharmed)
			|| killer->IsFlagged(EMobFlag::kTutelar)
			|| killer->IsFlagged(EMobFlag::kMentalShadow))
		&& killer->has_master()) {
		master = killer->get_master();
	} else if (!killer->IsNpc()) {
		master = killer;
	}

	//    master - PC
	if (master) {
		int cnt = 0;
		if (AFF_FLAGGED(master, EAffect::kGroup)) {

			// master -  ,    
			if (master->has_master()) {
				master = master->get_master();
			}

			if (master->in_room == killer->in_room) {
				//     ,   
				cnt = 1;
				if (CanUseFeat(master, EFeat::kPartner)) {
					leader_partner = true;
				}
			}

			for (struct FollowerType *f = master->followers; f; f = f->next) {
				if (AFF_FLAGGED(f->follower, EAffect::kGroup)) ++total_group_members;
				if (AFF_FLAGGED(f->follower, EAffect::kGroup)
					&& f->follower->in_room == killer->in_room) {
					++cnt;
					if (leader_partner) {
						if (!f->follower->IsNpc()) {
							partner_feat++;
							partner = f->follower;
						}
					}
				}
			}
		}

		//  ,    
		//     2  ,       
		if (leader_partner
			&& partner_feat == 1 && total_group_members == 2) {
			master->mobmax_add(master, GET_MOB_VNUM(ch), 1, GetRealLevel(ch));
			partner->mobmax_add(partner, GET_MOB_VNUM(ch), 1, GetRealLevel(ch));
		} else if (total_group_members > 12) {
			//        (  >12 )
			// +1      4   12
			// : (13-15)->2 (16-19)->3 20->4
			const int above_limit = total_group_members - 12;
			const int mobmax_members = (above_limit / 4) + 2;

			//         
			std::vector<CharData *> members_to_mobmax;
			if (master->in_room == killer->in_room) {
				members_to_mobmax.push_back(master);
			}
			for (struct FollowerType *f = master->followers; f; f = f->next) {
				if (AFF_FLAGGED(f->follower, EAffect::kGroup)
					&& f->follower->in_room == killer->in_room) {
					members_to_mobmax.push_back(f->follower);
				}
			}

			//    
			std::shuffle(members_to_mobmax.begin(), members_to_mobmax.end(), std::mt19937(std::random_device()()));
			const int actual_size_to_mobmax = std::min(static_cast<int>(members_to_mobmax.size()), mobmax_members);
			members_to_mobmax.resize(actual_size_to_mobmax);

			for (const auto &member : members_to_mobmax) {
				member->mobmax_add(member, GET_MOB_VNUM(ch), 1, GetRealLevel(ch));
			}
		} else {
			//       
			auto n = number(0, cnt);
			int i = 0;
			for (struct FollowerType *f = master->followers; f && i < n; f = f->next) {
				if (AFF_FLAGGED(f->follower, EAffect::kGroup)
					&& f->follower->in_room == killer->in_room) {
					++i;
					master = f->follower;
				}
			}
			master->mobmax_add(master, GET_MOB_VNUM(ch), 1, GetRealLevel(ch));
		}
	}
}

bool stone_rebirth(CharData *ch, CharData *killer) {
	RoomRnum rnum_start, rnum_stop;
	if (ch->IsNpc()){
		return false;
	}
	if (killer && (!killer->IsNpc() || IS_CHARMICE(killer)) && (ch != killer)) { //   
		return false;
	}
	GetZoneRooms(world[ch->in_room]->zone_rn, &rnum_start, &rnum_stop);
	for (; rnum_start <= rnum_stop; rnum_start++) {
		RoomData *rm = world[rnum_start];
		if (rm->contents) {
			for (ObjData *j = rm->contents; j; j = j->get_next_content()) {
				if (j->get_vnum() == 1000) { //  
					act("$n $q  .", false, ch, nullptr, nullptr, kToRoom);
					SendMsgToChar("    !\r\n", ch);
					RemoveCharFromRoom(ch);
					PlaceCharToRoom(ch, rnum_start);
					ch->dismount();
					ch->set_hit(1);
					update_pos(ch);
					while (!ch->affected.empty()) {
						ch->AffectRemove(ch->affected.begin());
					}
					affect_total(ch);
					ch->SetPosition(EPosition::kStand);
					look_at_room(ch, 0);
					greet_mtrigger(ch, -1);
					greet_otrigger(ch, -1);
					act("$n  $u -.", false, ch, nullptr, nullptr, kToRoom);
					SetWaitState(ch, 10 * kBattleRound);
					return true;
				}
			}
		}
	}
	return false;
}

bool check_tester_death(CharData *ch, CharData *killer) {
	const bool player_died = !ch->IsNpc();
	const bool zone_is_under_construction = InTestZone(ch);

	if (!player_died || !zone_is_under_construction) {
		return false;
	}

	if (killer && (!killer->IsNpc() || IS_CHARMICE(killer))
		&& (ch != killer)) //         
	{
		return false;
	}

	//        .      true.
	//  ,        ߣ -.
	act("$n $q  .", false, ch, nullptr, nullptr, kToRoom);
	const int rent_room = GetRoomRnum(GET_LOADROOM(ch));
	if (rent_room == kNowhere) {
		SendMsgToChar("  !\r\n", ch);
		return true;
	}
//	enter_wtrigger(world[rent_room], ch, -1);
	SendMsgToChar("    .!\r\n", ch);
	RemoveCharFromRoom(ch);
	PlaceCharToRoom(ch, rent_room);
	ch->dismount();
	ch->set_hit(1);
	update_pos(ch);
	act("$n  $u -.", false, ch, nullptr, nullptr, kToRoom);
	while (!ch->affected.empty()) {
		ch->AffectRemove(ch->affected.begin());
	}
	affect_total(ch);
	ch->SetPosition(EPosition::kStand);
	look_at_room(ch, 0);
	greet_mtrigger(ch, -1);
	greet_otrigger(ch, -1);
	return true;
}

void die(CharData *ch, CharData *killer) {
	long dec_exp = 0;
	auto char_exp = ch->get_exp();

	if (!ch->IsNpc() && (ch->in_room == kNowhere)) {
		log("SYSERR: %s is dying in room kNowhere.", GET_NAME(ch));
		return;
	}
	if (check_tester_death(ch, killer)) {
		return;
	}
	if (stone_rebirth(ch, killer)) {
		return;
	}
	if (!ch->IsNpc() && (GetZoneVnumByCharPlace(ch) == 759)
		&& (GetRealLevel(ch) < 15)) //   
	{
		act("$n  $q   .", false, ch, nullptr, nullptr, kToRoom);
		RemoveCharFromRoom(ch);
		PlaceCharToRoom(ch, GetRoomRnum(75989));
		ch->dismount();
		ch->set_hit(1);
		update_pos(ch);
		act("$n  $u -.", false, ch, nullptr, nullptr, kToRoom);
		look_at_room(ch, 0);
		greet_mtrigger(ch, -1);
		greet_otrigger(ch, -1);
//		WAIT_STATE(ch, 10 * kBattleRound);    
		return;
	}

	if (ch->IsNpc()
		|| !ROOM_FLAGGED(ch->in_room, ERoomFlag::kArena)
		|| NORENTABLE(ch)) {
		if (!(ch->IsNpc()
			|| IS_IMMORTAL(ch)
			|| GET_GOD_FLAG(ch, EGf::kGodsLike)
			|| (killer && killer->IsFlagged(EPrf::kExecutor))))//   
		{
			if (!NORENTABLE(ch))
				dec_exp =
					(GetExpUntilNextLvl(ch, GetRealLevel(ch) + 1) - GetExpUntilNextLvl(ch, GetRealLevel(ch))) / (3 + std::min(3, GetRealRemort(ch) / 5))
						/ ch->death_player_count();
			else
				dec_exp = (GetExpUntilNextLvl(ch, GetRealLevel(ch) + 1) - GetExpUntilNextLvl(ch, GetRealLevel(ch)))
					/ (3 + std::min(3, GetRealRemort(ch) / 5));
			EndowExpToChar(ch, -dec_exp);
			dec_exp = char_exp - ch->get_exp();
			sprintf(buf, "  %ld %s .\r\n", dec_exp, GetDeclensionInNumber(dec_exp, EWhat::kPoint));
			SendMsgToChar(buf, ch);
		}

		//    
		//   ,   ,
		//  ,       
		if (ch->IsNpc() && killer) {
			process_mobmax(ch, killer);
		}
		if (killer) {
			UpdateLeadership(ch, killer);
		}
	}
	CharStat::UpdateOnKill(ch, killer, dec_exp);
	raw_kill(ch, killer);
}

/*    ""  "",
                        */
int can_loot(CharData *ch) {
	if (ch != nullptr) {
		if (!ch->IsNpc()
			&& AFF_FLAGGED(ch, EAffect::kHold) == 0 //   
			&& !AFF_FLAGGED(ch, EAffect::kStopFight) //  
			&& !AFF_FLAGGED(ch, EAffect::kBlind)    // 
			&& (ch->GetPosition() >= EPosition::kRest)) // , ,  , 
		{
			return true;
		}
	}
	return false;
}

void death_cry(CharData *ch, CharData *killer) {
	int door;
	if (killer) {
		if (IS_CHARMICE(killer)) {
			if (killer->get_master() && killer->get_master()->in_room == killer->in_room) {
				act("       $N1.",
					false, killer->get_master(), nullptr, ch, kToRoom | kToNotDeaf);
			}
		} else {
			act("       $N1.",
				false, killer, nullptr, ch, kToRoom | kToNotDeaf);
		}
	}

	for (door = 0; door < EDirection::kMaxDirNum; door++) {
		if (CAN_GO(ch, door)) {
			const auto room_number = world[ch->in_room]->dir_option[door]->to_room();
			const auto room = world[room_number];
			if (!room->people.empty()) {
				act("     -  .",
					false, room->first_character(), nullptr, nullptr, kToChar | kToNotDeaf);
				act("     -  .",
					false, room->first_character(), nullptr, nullptr, kToRoom | kToNotDeaf);
			}
		}
	}
}
void arena_kill(CharData *ch, CharData *killer) {
	make_arena_corpse(ch, killer);
	//        
	if (killer && killer->IsFlagged(EPrf::kExecutor)) {
		killer->set_gold(ch->get_gold() + killer->get_gold());
		ch->set_gold(0);
	}
	change_fighting(ch, true);
	ch->set_hit(1);
	ch->DropFromHorse();
	ch->SetPosition(EPosition::kSit);
	int to_room = GetRoomRnum(GET_LOADROOM(ch));
	//       ,      
	if (!Clan::MayEnter(ch, to_room, kHousePortal)) {
		to_room = Clan::CloseRent(to_room);
	}
	if (to_room == kNowhere) {
		ch->SetFlag(EPlrFlag::kHelled);
		HELL_DURATION(ch) = time(nullptr) + 6;
		to_room = r_helled_start_room;
	}
	for (FollowerType *f = ch->followers; f; f = f->next) {
		if (IS_CHARMICE(f->follower)) {
			RemoveCharFromRoom(f->follower);
			PlaceCharToRoom(f->follower, to_room);
		}
	}
	for (int i=0; i < MAX_FIRSTAID_REMOVE; i++) {
		RemoveAffectFromChar(ch, GetRemovableSpellId(i));
	}
	//  
	RemoveAffectFromChar(ch, ESpell::kAconitumPoison);
	RemoveAffectFromChar(ch, ESpell::kDaturaPoison);
	RemoveAffectFromChar(ch, ESpell::kScopolaPoison);
	RemoveAffectFromChar(ch, ESpell::kBelenaPoison);
	affect_total(ch);
	RemoveCharFromRoom(ch);
	PlaceCharToRoom(ch, to_room);
	look_at_room(ch, to_room);
	act("$n   $g  ...", false, ch, nullptr, nullptr, kToRoom);
	enter_wtrigger(world[ch->in_room], ch, -1);
}

void auto_loot(CharData *ch, CharData *killer, ObjData *corpse, int local_gold) {
	char obj[256];

	if (is_dark(killer->in_room)
		&& !(CAN_SEE_IN_DARK(killer) || CanUseFeat(killer, EFeat::kDarkReading))
		&& !(killer->IsNpc()
			&& AFF_FLAGGED(killer, EAffect::kCharmed)
			&& killer->has_master()
			&& CanUseFeat(killer->get_master(), EFeat::kDarkReading))) {
		return;
	}

	if (ch->IsNpc()
		&& !killer->IsNpc()
		&& killer->IsFlagged(EPrf::kAutoloot)
		&& (corpse != nullptr)
		&& can_loot(killer)) {
		sprintf(obj, "all");
		get_from_container(killer, corpse, obj, EFind::kObjInventory, 1, true);
	} else if (ch->IsNpc()
		&& !killer->IsNpc()
		&& local_gold
		&& killer->IsFlagged(EPrf::kAutomoney)
		&& (corpse != nullptr)
		&& can_loot(killer)) {
		sprintf(obj, "all.coin");
		get_from_container(killer, corpse, obj, EFind::kObjInventory, 1, false);
	} else if (ch->IsNpc()
		&& killer->IsNpc()
		&& (AFF_FLAGGED(killer, EAffect::kCharmed)
			|| killer->IsFlagged(EMobFlag::kTutelar)
			|| killer->IsFlagged(EMobFlag::kMentalShadow))
		&& (corpse != nullptr)
		&& killer->has_master()
		&& killer->in_room == killer->get_master()->in_room
		&& killer->get_master()->IsFlagged(EPrf::kAutoloot)
		&& can_loot(killer->get_master())) {
		sprintf(obj, "all");
		get_from_container(killer->get_master(), corpse, obj, EFind::kObjInventory, 1, true);
	} else if (ch->IsNpc()
		&& killer->IsNpc()
		&& local_gold
		&& (AFF_FLAGGED(killer, EAffect::kCharmed)
			|| killer->IsFlagged(EMobFlag::kTutelar)
			|| killer->IsFlagged(EMobFlag::kMentalShadow))
		&& (corpse != nullptr)
		&& killer->has_master()
		&& killer->in_room == killer->get_master()->in_room
		&& killer->get_master()->IsFlagged(EPrf::kAutomoney)
		&& can_loot(killer->get_master())) {
		sprintf(obj, "all.coin");
		get_from_container(killer->get_master(), corpse, obj, EFind::kObjInventory, 1, false);
	}
}

void check_spell_capable(CharData *ch, CharData *killer) {
	if (ch->IsNpc()
		&& killer
		&& killer != ch
		&& ch->IsFlagged(EMobFlag::kClone)
		&& ch->has_master()
		&& IsAffectedBySpell(ch, ESpell::kCapable)) {
		RemoveAffectFromCharAndRecalculate(ch, ESpell::kCapable);
		act(",   $n3,        .",
			false, ch, nullptr, killer, kToRoom | kToArenaListen);
		auto pos = ch->GetPosition();
		ch->SetPosition(EPosition::kStand);
		CallMagic(ch, killer, nullptr, world[ch->in_room], ch->mob_specials.capable_spell, GetRealLevel(ch));
		ch->SetPosition(pos);
	}
}

void clear_mobs_memory(CharData *ch) {
	for (const auto &hitter : character_list) {
		if (hitter->IsNpc() && MEMORY(hitter)) {
			mob_ai::mobForget(hitter.get(), ch);
		}
	}
}

bool change_rep(CharData *ch, CharData *killer) {
	return false;
	// ,     
	if ((!CLAN(ch)) || (!CLAN(killer)))
		return false;
	//    
	if (CLAN(ch) == CLAN(killer))
		return false;

	// 1/10     
	int rep_ch = CLAN(ch)->get_rep() * 0.1 + 1;
	CLAN(ch)->set_rep(CLAN(ch)->get_rep() - rep_ch);
	CLAN(killer)->set_rep(CLAN(killer)->get_rep() + rep_ch);
	SendMsgToChar("     !    .\r\n", ch);
	SendMsgToChar("      !    .\r\n", killer);
	//     
	if (CLAN(ch)->get_rep() < 1) {
		//  
		//CLAN(ch)->bank = 0;
	}
	return true;
}

void real_kill(CharData *ch, CharData *killer) {
	const long local_gold = ch->get_gold();
	ObjData *corpse = make_corpse(ch, killer);
	utils::CSteppedProfiler round_profiler(fmt::format("real_kill"), 0.01);

	round_profiler.next_step("handle_corpse");
	bloody::handle_corpse(corpse, ch, killer);
	//   pk_revenge_action  die,    
	//       
	if (ch->IsNpc() || !ROOM_FLAGGED(ch->in_room, ERoomFlag::kArena) || NORENTABLE(ch)) {
		round_profiler.next_step("pk_revenge_action");
		pk_revenge_action(killer, ch);
	}
	if (!ch->IsNpc()) {
		forget_all_spells(ch);
		clear_mobs_memory(ch);
		//     -     
		ch->player_specials->may_rent = 0;
		AGRESSOR(ch) = 0;
		AGRO(ch) = 0;
		ch->agrobd = false;
#if defined WITH_SCRIPTING
		//scripting::on_pc_dead(ch, killer, corpse);
#endif
	} else {
		if (killer && (!killer->IsNpc() || IS_CHARMICE(killer))) {
			log("Killed: %d %d %ld", GetRealLevel(ch), ch->get_max_hit(), ch->get_exp());
			obj_load_on_death(corpse, ch);
		}
		if (ch->IsFlagged(EMobFlag::kCorpse)) {
			round_profiler.next_step("PerformDropGold");
			PerformDropGold(ch, local_gold);
			ch->set_gold(0);
		}
		round_profiler.next_step("LoadObjFromDeadLoad");
		dead_load::LoadObjFromDeadLoad(corpse, ch, nullptr, dead_load::kOrdinary);
#if defined WITH_SCRIPTING
		//scripting::on_npc_dead(ch, killer, corpse);
#endif
	}
/*	  
	if (!ch->IsNpc() && GetRealRemort(ch) > 7 && (GetRealLevel(ch) == 29 || GetRealLevel(ch) == 30))
	{
		//    
		const auto rnum = GetObjRnum(100);
		if (rnum >= 0)
		{
			const auto o = world_objects.create_from_prototype_by_rnum(rnum);
			o->set_owner(ch->get_uid());
			obj_to_obj(o.get(), corpse);
		}

	}
*/
	//    ""  " "    damage,
	//  ,    .  ,
	//       ,    
	round_profiler.next_step("auto_loot");
	if ((ch != nullptr) && (killer != nullptr)) {
		auto_loot(ch, killer, corpse, local_gold);
	}
}

void raw_kill(CharData *ch, CharData *killer) {
	check_spell_capable(ch, killer);
	if (ch->GetEnemy()) {
		stop_fighting(ch, true);
	}
	for (auto &hitter : combat_list) {
		if (hitter.deleted)
			continue;
		if (hitter.ch->GetEnemy() == ch) {
			SetWaitState(hitter.ch, 0);
		}
	}
	if (!ch || ch->purged()) {
//		debug::coredump();
		debug::backtrace(runtime_config.logs(ERRLOG).handle());
		mudlog("SYSERR:  - -      ,    .     .",
				NRM, kLvlGod, ERRLOG, true);
		return;
	}
	if (!ROOM_FLAGGED(ch->in_room, ERoomFlag::kDominationArena)) {
		reset_affects(ch);
	}
	//   ,   
	if ((!killer || death_mtrigger(ch, killer)) && ch->in_room != kNowhere) {
		death_cry(ch, killer);
	}

	if (killer && killer->IsNpc() && !ch->IsNpc() && kill_mtrigger(killer, ch)) {
		const auto it = std::find(killer->kill_list.begin(), killer->kill_list.end(), ch->get_uid());
		if (it != killer->kill_list.end()) {
			killer->kill_list.erase(it);
		}
		killer->kill_list.push_back(ch->get_uid());
	}

	//    
	if (ch->IsNpc() && killer) {
		if (CanUseFeat(killer, EFeat::kSoulsCollector)) {
			if (GetRealLevel(ch) >= GetRealLevel(killer)) {
				if (killer->get_souls() < (GetRealRemort(killer) + 1)) {
					act("&G   $N1 !&n", false, killer, nullptr, ch, kToChar);
					act("$n   $N1 !", false, killer, nullptr, ch, kToNotVict | kToArenaListen);
					killer->inc_souls();
				}
			}
		}
	}
	if (ch->in_room != kNowhere) {
		if (killer && (!killer->IsNpc() || IS_CHARMICE(killer)) && !ch->IsNpc())
 			kill_pc_wtrigger(killer, ch);
		if (!ch->IsNpc() && (!NORENTABLE(ch) && ROOM_FLAGGED(ch->in_room, ERoomFlag::kArena))) {
			//   
			arena_kill(ch, killer);
		} else if (change_rep(ch, killer)) {
			//    
			arena_kill(ch, killer);
		} else {
			real_kill(ch, killer);
			character_list.AddToExtractedList(ch);
//			ExtractCharFromWorld(ch, true);
		}
	}
}

int get_remort_mobmax(CharData *ch) {
	int remort = GetRealRemort(ch);
	if (remort >= 18)
		return 15;
	if (remort >= 14)
		return 7;
	if (remort >= 9)
		return 4;
	return 0;
}

//        .
//      ,       x10 .
int get_npc_long_live_exp_bounus(CharData *victim) {
	if (GET_MOB_VNUM(victim) == -1) {
		return 1;
	}
	if (GET_MOB_VNUM(victim) / 100 >= dungeons::kZoneStartDungeons) {
		return 1;
	}

	int exp_multiplier = 1;

	const auto last_kill_time = mob_stat::GetMobKilllastTime(GET_MOB_VNUM(victim));
	if (last_kill_time > 0) {
		const auto now_time = time(nullptr);
		if (now_time > last_kill_time) {
			const auto delta_time = now_time - last_kill_time;
			constexpr long delay = 60 * 60 * 24 * 30; // 30 days
			exp_multiplier = std::clamp(static_cast<int>(floor(delta_time / delay)), 1, 10);
		}
	}

	return exp_multiplier;
}

long long get_extend_exp(long long exp, CharData *ch, CharData *victim) {
	int base, diff;
	int koef;

	if (!victim->IsNpc() || ch->IsNpc())
		return (exp);

	ch->send_to_TC(false, true, false,
				   "&R   %d   ,  %d,  %d&n\r\n",
				   mob_proto[victim->get_rnum()].mob_specials.MaxFactor,
				   exp,
				   ch->mobmax_get(GET_MOB_VNUM(victim)));

	exp += static_cast<int>(exp * (ch->add_abils.percent_exp_add) / 100.0);
	for (koef = 100, base = 0, diff =
		ch->mobmax_get(GET_MOB_VNUM(victim)) - mob_proto[victim->get_rnum()].mob_specials.MaxFactor;
		 base < diff && koef > 5; base++, koef = koef * (95 - get_remort_mobmax(ch)) / 100);
	//     15%   
	exp = exp * std::max(15, koef) / 100;

	//   
	exp /= std::max(1.0, 0.5 * (GetRealRemort(ch) - kMaxExpCoefficientsUsed));
	return (exp);
}

// When ch kills victim
void change_alignment(CharData *ch, CharData *victim) {
	/*
	 * new alignment change algorithm: if you kill a monster with alignment A,
	 * you move 1/16th of the way to having alignment -A.  Simple and fast.
	 */
	GET_ALIGNMENT(ch) += (-GET_ALIGNMENT(victim) - GET_ALIGNMENT(ch)) / 16;
}

/*++
     
      ch -   
               NPC   ,   
           -     
--*/
void perform_group_gain(CharData *ch, CharData *victim, int members, int koef) {


// ,   NPC     
//  if (ch->IsNpc() || !OK_GAIN_EXP(ch,victim))
	if (!OK_GAIN_EXP(ch, victim)) {
		SendMsgToChar("    .\r\n", ch);
		return;
	}

	// 1.     
	long long exp = victim->get_exp() / std::max(members, 1);
	int long_live_exp_bounus_miltiplier = 1;

	if (victim->get_zone_group() > 1 && members < victim->get_zone_group()) {
		//   -      -   
		exp = victim->get_exp() / victim->get_zone_group();
	}
	// 2.   (,  )
	//               ,
	//          
	exp = exp * koef / 100;
	// 3.    PC  NPC
	if (!NPC_FLAGGED(victim, ENpcFlag::kIgnoreRareKill)) {
		long_live_exp_bounus_miltiplier = get_npc_long_live_exp_bounus(victim);
	}
	if (ch->IsNpc()) {
		exp = std::min(static_cast<long long>(max_exp_gain_npc), exp);
		exp += std::max(static_cast<long long>(0), (exp * std::min(0, (GetRealLevel(victim) - GetRealLevel(ch)))) / 8);
	} else
		exp = std::min(static_cast<long long>(max_exp_gain_pc(ch)), get_extend_exp(exp, ch, victim) * long_live_exp_bounus_miltiplier);
	// 4.  
	exp = std::max(static_cast<long long>(1), exp);
	if (exp > 1) {
		if (Bonus::is_bonus_active(Bonus::EBonusType::BONUS_EXP) && Bonus::can_get_bonus_exp(ch)) {
			exp *= Bonus::get_mult_bonus();
		}

		if (!ch->IsNpc() && !ch->affected.empty() && Bonus::can_get_bonus_exp(ch)) {
			for (const auto &aff : ch->affected) {
				if (aff->location == EApply::kExpBonus) //     
				{
					exp *= std::min(3, aff->modifier); //   
				}
			}
		}

		if (long_live_exp_bounus_miltiplier > 1) {
			std::string mess;
			switch (long_live_exp_bounus_miltiplier) {
				case 2: mess = " !  !\r\n";
					break;
				case 3: mess = "  !  !\r\n";
					break;
				case 4: mess = "-  !  !\r\n";
					break;
				case 5: mess = " !  !\r\n";
					break;
				case 6: mess = "  !  !\r\n";
					break;
				case 7: mess = "   !  !\r\n";
					break;
				case 8: mess = "   !  !\r\n";
					break;
				case 9: mess = "   !  !\r\n";
					break;
				default: mess = "   !  !\r\n";
					break;
			}
			SendMsgToChar(mess.c_str(), ch);
		}
		if (long_live_exp_bounus_miltiplier >= 10) {
			const CharData *ch_with_bonus = ch->IsNpc() ? ch->get_master() : ch;
			if (ch_with_bonus && !ch_with_bonus->IsNpc()) {
				std::stringstream str_log;
				str_log << "[INFO] " << ch_with_bonus->get_name() << " () x" << long_live_exp_bounus_miltiplier << "    : [";
				str_log << GET_MOB_VNUM(victim) << "] " << victim->get_name();
				mudlog(str_log.str(), NRM, kLvlImmortal, SYSLOG, true);
			}
		}

		exp = std::min(static_cast<long long>(max_exp_gain_pc(ch)), exp);
		SendMsgToChar(ch, "    %lld %s.\r\n", exp, GetDeclensionInNumber(exp, EWhat::kPoint));
	} else if (exp == 1) {
		SendMsgToChar("       .\r\n", ch);
	}
	if (!InTestZone(ch)) {
		EndowExpToChar(ch, exp);
		change_alignment(ch, victim);
		TopPlayer::Refresh(ch);
		if (!EXTRA_FLAGGED(victim, EXTRA_GRP_KILL_COUNT)
				&& !ch->IsNpc()
				&& !IS_IMMORTAL(ch)
				&& victim->IsNpc()
				&& !IS_CHARMICE(victim)
				&& !ROOM_FLAGGED(victim->in_room, ERoomFlag::kArena)) {
				mob_stat::AddMob(victim, members);
				EXTRA_FLAGS(victim).set(EXTRA_GRP_KILL_COUNT);
		} else if (ch->IsNpc() && !victim->IsNpc()
			&& !ROOM_FLAGGED(victim->in_room, ERoomFlag::kArena)) {
			mob_stat::AddMob(ch, 0);
		}
	}
}

/*++
           ,
          
 ..      PC,       PC

   ch -   ,   :
            1.   NPC
            2.      (  )

     PC-    

--*/
void group_gain(CharData *killer, CharData *victim) {
	int inroom_members, koef = 100, maxlevel;
	struct FollowerType *f;
	int partner_count = 0;
	int total_group_members = 1;
	bool use_partner_exp = false;

	//   ,    
	if (CanUseFeat(killer, EFeat::kCynic)) {
		maxlevel = 300;
	} else {
		maxlevel = GetRealLevel(killer);
	}

	auto leader = killer->get_master();
	if (nullptr == leader) {
		leader = killer;
	}

	// k -    
	const bool leader_inroom = AFF_FLAGGED(leader, EAffect::kGroup)
		&& leader->in_room == killer->in_room;

	//    
	if (leader_inroom) {
		inroom_members = 1;
		maxlevel = GetRealLevel(leader);
	} else {
		inroom_members = 0;
	}

	//     
	for (f = leader->followers; f; f = f->next) {
		if (AFF_FLAGGED(f->follower, EAffect::kGroup)) ++total_group_members;
		if (AFF_FLAGGED(f->follower, EAffect::kGroup)
			&& f->follower->in_room == killer->in_room) {
			//    ,     
			//         
			//  300,     
			if (CanUseFeat(f->follower, EFeat::kCynic)) {
				maxlevel = 300;
			}
			//       
			//   => PC 
			++inroom_members;
			maxlevel = std::max(maxlevel, GetRealLevel(f->follower));
			if (!f->follower->IsNpc()) {
				partner_count++;
			}
		}
	}

	GroupPenaltyCalculator group_penalty(killer, leader, maxlevel, grouping);
	koef -= group_penalty.get();

	koef = std::max(0, koef);

	if (leader_inroom) {
		koef += CalcLeadershipGroupExpKoeff(leader, inroom_members, koef);
	}

	//  
	//      
	if (zone_table[world[killer->in_room]->zone_rn].group < 2) {
		//     ,       
		//  ,      
		use_partner_exp = total_group_members == 2;
	}

	//     
	if (leader_inroom) {
		//       
		if (CanUseFeat(leader, EFeat::kPartner) && use_partner_exp) {
			//      
			// k - ,   
			if (partner_count == 1) {
				//   .    100
				if (koef >= 100) {
					if (leader->get_zone_group() < 2) {
						koef += 100;
					}
				}
			}
		}
		perform_group_gain(leader, victim, inroom_members, koef);
	}

	for (f = leader->followers; f; f = f->next) {
		if (AFF_FLAGGED(f->follower, EAffect::kGroup)
				&& f->follower->in_room == killer->in_room) {
			perform_group_gain(f->follower, victim, inroom_members, koef);
		}
	}
}

char *replace_string(const char *str, const char *weapon_singular, const char *weapon_plural) {
	static char buf[256];
	char *cp = buf;

	for (; *str; str++) {
		if (*str == '#') {
			switch (*(++str)) {
				case 'W':
					for (; *weapon_plural; *(cp++) = *(weapon_plural++)) {
					}
					break;
				case 'w':
					for (; *weapon_singular; *(cp++) = *(weapon_singular++)) {
					}
					break;
				default: *(cp++) = '#';
					break;
			}
		} else
			*(cp++) = *str;

		*cp = 0;
	}            // For

	return (buf);
}

bool check_valid_chars(CharData *ch, CharData *victim, const char *fname, int line) {
	if (!ch || ch->purged() || !victim || victim->purged()) {
		log("SYSERROR: ch = %s, victim = %s (%s:%d)",
			ch ? (ch->purged() ? "purged" : "true") : "false",
			victim ? (victim->purged() ? "purged" : "true") : "false",
			fname, line);
		return false;
	}
	return true;
}

/*
 * Alert: As of bpl14, this function returns the following codes:
 *	< 0	Victim  died.
 *	= 0	No damage.
 *	> 0	How much damage done.
 */

void char_dam_message(int dam, CharData *ch, CharData *victim, bool noflee) {
	if (ch->in_room == kNowhere)
		return;
	if (!victim || victim->purged())
		return;
	switch (victim->GetPosition()) {
		case EPosition::kPerish:
			if (IS_POLY(victim))
				act("$n    ,    .",
					true, victim, nullptr, nullptr, kToRoom | kToArenaListen);
			else
				act("$n  $a  ,  $m  .",
					true, victim, nullptr, nullptr, kToRoom | kToArenaListen);
			SendMsgToChar("    ,    .\r\n", victim);
			break;
		case EPosition::kIncap:
			if (IS_POLY(victim))
				act("$n     .   .",
					true, victim, nullptr, nullptr, kToRoom | kToArenaListen);
			else
				act("$n     .   $m.",
					true, victim, nullptr, nullptr, kToRoom | kToArenaListen);
			SendMsgToChar("     ,   .\r\n", victim);
			break;
		case EPosition::kStun:
			if (IS_POLY(victim))
				act("$n  ,      ( :).",
					true, victim, nullptr, nullptr, kToRoom | kToArenaListen);
			else
				act("$n  ,   $e   ( :).",
					true, victim, nullptr, nullptr, kToRoom | kToArenaListen);
			SendMsgToChar("  .       .\r\n", victim);
			break;
		case EPosition::kDead:
			if (victim->IsNpc() && (victim->IsFlagged(EMobFlag::kCorpse))) {
				act("$n $g  $u  .", false, victim, nullptr, nullptr, kToRoom | kToArenaListen);
				SendMsgToChar("       !\r\n", victim);
			} else {
				if (IS_POLY(victim))
					act("$n ,      .",
						false, victim, nullptr, nullptr, kToRoom | kToArenaListen);
				else
					act("$n $a, $s     .",
						false, victim, nullptr, nullptr, kToRoom | kToArenaListen);
				SendMsgToChar(" !   ...\r\n", victim);
			}
			break;
		default:        // >= POSITION SLEEPING
			if (dam > (victim->get_real_max_hit() / 4)) {
				SendMsgToChar("  !\r\n", victim);
			}

			if (dam > 0
				&& victim->get_hit() < (victim->get_real_max_hit() / 4)) {
				sprintf(buf2, "%s  ,       ! %s\r\n",
						kColorRed, kColorNrm);
				SendMsgToChar(buf2, victim);
			}

			if (ch != victim
				&& victim->IsNpc()
				&& victim->get_hit() < (victim->get_real_max_hit() / 4)
				&& victim->IsFlagged(EMobFlag::kWimpy)
				&& !noflee
				&& victim->GetPosition() > EPosition::kSit) {
				DoFlee(victim, nullptr, 0, 0);
			}

			if (ch != victim
				&& victim->GetPosition() > EPosition::kSit
				&& !victim->IsNpc()
				&& HERE(victim)
				&& GET_WIMP_LEV(victim)
				&& victim->get_hit() < GET_WIMP_LEV(victim)
				&& !noflee) {
				SendMsgToChar("    !\r\n", victim);
				DoFlee(victim, nullptr, 0, 0);
			}

			break;
	}
}

void do_show_mobmax(CharData *ch, char *, int, int) {
	const auto player = dynamic_cast<Player *>(ch);
	if (nullptr == player) {
		//   ,  show_mobmax    
		return;
	}
	SendMsgToChar(ch, "&B  !!!&n\n");
	player->show_mobmax();
}
// vim: ts=4 sw=4 tw=0 noet syntax=cpp :
