#include "fight_extra_attack.h"
#include "engine/entities/char_data.h"
#include "gameplay/magic/spells.h"
#include "utils/utils.h"

WeaponMagicalAttack::WeaponMagicalAttack(CharacterData *ch) { ch_ = ch; }

void WeaponMagicalAttack::set_attack(CharacterData *ch, CharacterData *victim) {
	ObjectData *mag_cont;

	mag_cont = GET_EQ(ch, WEAR_QUIVER);
	if (GET_OBJ_VAL(mag_cont, 2) <= 0) {
		act("     ,    .", false, ch, 0, 0, TO_CHAR);
		act("$n $g    $g  .", false, ch, 0, 0, TO_ROOM | TO_ARENA_LISTEN);
		mag_cont->set_val(2, 0);
		return;
	}

	mag_single_target(GetRealLevel(ch), ch, victim, nullptr, GET_OBJ_VAL(mag_cont, 0), ESaving::SAVING_REFLEX);
}

bool WeaponMagicalAttack::set_count_attack(CharacterData *ch) {
	ObjectData *mag_cont;
	mag_cont = GET_EQ(ch, WEAR_QUIVER);
	//sprintf(buf, "  %d", get_count());
	//act(buf, true, ch, 0, 0, TO_ROOM | TO_ARENA_LISTEN);
	//  
	if ((GET_EQ(ch, WEAR_BOTHS) && GET_EQ(ch, WEAR_BOTHS)->get_type() == EObjType::kWeapon))
		&& (GET_OBJ_SKILL(GET_EQ(ch, WEAR_BOTHS)) == SKILL_BOWS)
		&& (GET_EQ(ch, WEAR_QUIVER))) {
		//        
		set_count(get_count() + 1);

		//   4  
		if (get_count() >= 4) {
			set_count(0);
			mag_cont->add_val(2, -1);
			return true;

		} else if ((CanFeat(ch, EFeat::kDeftShooter)) && (get_count() == 3)) {
			set_count(0);
			mag_cont->add_val(2, -1);
			return true;
		}
		return false;
	}
	set_count(0);
	return false;
}
