#include "common.h"

#include "gameplay/skills/parry.h"
#include "engine/core/handler.h"

int IsHaveNoExtraAttack(CharData *ch) {
	std::string message = "";
	CheckParryOverride(ch);
	if (ch->GetExtraVictim()) {
		switch (ch->get_extra_attack_mode()) {
			case kExtraAttackBash: message = ".    $N3.";
				break;
			case kExtraAttackKick: message = ".    $N3.";
				break;
			case kExtraAttackChopoff: message = ".    $N3.";
				break;
			case kExtraAttackDisarm: message = ".    $N3.";
				break;
			case kExtraAttackThrow: message = ".      $N3.";
				break;
			case kExtraAttackCut: message = ".       $N1.";
				break;
			case kExtraAttackSlay: message = ".    $N3.";
				break;
			default: return false;
		}
	} else {
		return true;
	};

	act(message.c_str(), false, ch, nullptr, ch->GetExtraVictim(), kToChar);
	return false;
}

void SetWait(CharData *ch, int waittime, int wait_if_fight) {
	if (!IS_IMMORTAL(ch) && (!wait_if_fight || (ch->GetEnemy() && ch->isInSameRoom(ch->GetEnemy())))) {
		SetWaitState(ch, waittime * kBattleRound);
	}
}

void SetSkillCooldown(CharData *ch, ESkill skill, int pulses) {
	if (ch->getSkillCooldownInPulses(skill) < pulses) {
		ch->setSkillCooldown(skill, pulses * kBattleRound + 1);
	}
}

void SetSkillCooldownInFight(CharData *ch, ESkill skill, int pulses) {
	if (ch->GetEnemy() && ch->isInSameRoom(ch->GetEnemy())) {
		SetSkillCooldown(ch, skill, pulses);
	} else {
		SetWaitState(ch, kBattleRound / 6);
	}
}

CharData *FindVictim(CharData *ch, char *argument) {
	one_argument(argument, arg);
	CharData *victim = get_char_vis(ch, arg, EFind::kCharInRoom);
	if (!victim) {
		if (!*arg && ch->GetEnemy() && ch->isInSameRoom(ch->GetEnemy())) {
			victim = ch->GetEnemy();
		}
	}
	return victim;
}
