/* ****************************************************************************
* File: house.h                                                Part of Bylins *
* Usage: Handling of clan system                                              *
* (c) 2005 Krodo                                                              *
******************************************************************************/

#ifndef HOUSE_H_
#define HOUSE_H_

#include "engine/ui/interpreter.h"
#include "house_exp.h"
#include "gameplay/communication/remember.h"
#include "engine/db/db.h"
#include "engine/core/conf.h"
#include "engine/structs/structs.h"
#include "engine/core/sysdep.h"

#include <vector>
#include <map>
#include <unordered_map>
#include <bitset>
#include <string>

namespace ClanSystem {

enum Privileges : unsigned {
  MAY_CLAN_INFO = 0,
  MAY_CLAN_ADD,
  MAY_CLAN_REMOVE,
  MAY_CLAN_PRIVILEGES,
  MAY_CLAN_CHANNEL,
  MAY_CLAN_POLITICS,
  MAY_CLAN_NEWS,
  MAY_CLAN_PKLIST,
  MAY_CLAN_CHEST_PUT,
  MAY_CLAN_CHEST_TAKE,
  MAY_CLAN_BANK,
  MAY_CLAN_EXIT,
  MAY_CLAN_MOD,
  MAY_CLAN_TAX,
  MAY_CLAN_BOARD,
  ///  
  CLAN_PRIVILEGES_NUM
};
const int MAX_GOLD_TAX_PCT = 50;
const int MIN_GOLD_TAX_AMOUNT = 100;
bool is_alliance(CharData *ch, char *clan_abbr);
void check_player_in_house();
bool is_ingr_chest(ObjData *obj);
void save_ingr_chests();
bool show_ingr_chest(ObjData *obj, CharData *ch);
void save_chest_log();
//   
void tax_manage(CharData *ch, std::string &buffer);
//     
void init_xhelp();
///    -  gold 
/// \return   ,     
long do_gold_tax(CharData *ch, long gold);
void do_clanstuff(CharData *ch, char *argument, int/* cmd*/, int/* subcmd*/);
void DoShowPolitics(CharData *ch, char *argument, int/* cmd*/, int/* subcmd*/);
void DoHouse(CharData *ch, char *argument, int/* cmd*/, int/* subcmd*/);
void DoShowWars(CharData *ch, char *argument, int/* cmd*/, int/* subcmd*/);
void DoClanChannel(CharData *ch, char *argument, int/* cmd*/, int subcmd);
void DoClanList(CharData *ch, char *argument, int/* cmd*/, int/* subcmd*/);
void DoClanPkList(CharData *ch, char *argument, int/* cmd*/, int subcmd);
void DoWhoClan(CharData *ch, char * /*argument*/, int/* cmd*/, int/* subcmd*/);
void do_show_alliance(CharData *ch, char *argument, int/* cmd*/, int/* subcmd*/);
void DoStoreHouse(CharData *ch, char *argument, int/* cmd*/, int/* subcmd*/);
void DoHcontrol(CharData *ch, char *argument, int/* cmd*/, int/* subcmd*/);
} // namespace ClanSystem

const int kPoliticsNeutral = 0;
const int kPoliticsWar = 1;
const int kPoliticsAlliance = 2;

const int kHouseAtrium = 0;
const int kHousePortal = 1;

//     ()
const int kChestUpdatePeriod = 10;
//       ()
const int kChestInvoicePeriod = 60;
//              ()
const int kClanTopRefreshPeriod = 360;
//    
const int kClanTax = 1000;
//         
const int kClanStorehouseTax = 1000;
//     ()  
const int kClanStorehouseCoeff = 50;

const int kMaxClanlevel = 5;
//     -
const int kClanStuffZone = 18;
const int kChestIdentPay = 110;

void fix_ingr_chest_rnum(const int room_rnum);//     

class ClanMember {
 public:
  using shared_ptr = std::shared_ptr<ClanMember>;

  ClanMember()
	  : rank_num{0}, money{0}, exp{0}, clan_exp{0}, level{0}, remort{false}, remorts_amount{0} {};

  std::string name;   //  
  int rank_num;       //  
  long long money;    //       
  long long exp;      //  -
  long long clan_exp; //  -

///    -
  //     (,  )
  int level;
  //      
  std::string class_abbr;
  //    
  bool remort;
  int remorts_amount;
};

struct ClanPk {
  long author;            //  
  std::string victimName;    //  
  std::string authorName;    //  
  time_t time;            //  
  std::string text;       // 
};

struct ClanStuffName {
  int num;
  std::string name;
  std::string desc;
  std::string longdesc;
  std::vector<std::string> PNames;
};

typedef std::shared_ptr<ClanPk> ClanPkPtr;
typedef std::map<long, ClanPkPtr> ClanPkList;
typedef std::vector<std::bitset<ClanSystem::CLAN_PRIVILEGES_NUM> > ClanPrivileges;
typedef std::map<int, int> ClanPolitics;
typedef std::vector<ClanStuffName> ClanStuffList;

class ClanMembersList : private std::unordered_map<long, ClanMember::shared_ptr> {
 public:
  using base_t = std::unordered_map<long, ClanMember::shared_ptr>;

  using base_t::key_type;
  using base_t::iterator;

  using base_t::begin;
  using base_t::end;
  using base_t::find;
  using base_t::size;
  using base_t::clear;

  void set(const key_type &key, const mapped_type &value) { (*this)[key] = value; }
  void set_rank(const key_type &key, const int rank) const { (*this).at(key)->rank_num = rank; }
  void add_money(const key_type &key, const long long money) { (*this).at(key)->money += money; }
  void sub_money(const key_type &key, const long long money) { (*this).at(key)->money -= money; }
  void erase(const const_iterator &i) { base_t::erase(i); }
};

class Clan {
 public:
  using shared_ptr = std::shared_ptr<Clan>;
  using ClanListType = std::vector<Clan::shared_ptr>;

  Clan();
  ~Clan();

  static ClanListType ClanList; //  

  static void ClanLoad();
  static void ClanLoadSingle(const std::string &index);
  static void ClanReload(const std::string &index);
  static void ClanSave();
  static void SaveChestAll();
  static void HconShow(CharData *ch);
  static void SetClanData(CharData *ch);
  static void ChestUpdate();
  static bool MayEnter(CharData *ch, RoomRnum room, bool mode);
  static bool InEnemyZone(CharData *ch);
  static bool PutChest(CharData *ch, ObjData *obj, ObjData *chest);
  static bool TakeChest(CharData *ch, ObjData *obj, ObjData *chest);
  static void ChestInvoice();
  static bool BankManage(CharData *ch, char *arg);
  static RoomRnum CloseRent(RoomRnum to_room);
  static shared_ptr GetClanByRoom(RoomRnum room);
  static void CheckPkList(CharData *ch);
  static void SyncTopExp();
  static bool ChestShow(ObjData *list, CharData *ch);
  static void remove_from_clan(long unique);
  static int print_spell_locate_object(CharData *ch, int count, std::string name);
  static std::string print_imm_where_obj(const ObjData *obj);
  static int GetClanWars(CharData *ch);
  static void init_chest_rnum();
  static bool is_clan_chest(ObjData *obj);
  static bool is_ingr_chest(ObjData *obj);
  static void clan_invoice(CharData *ch, bool enter);
  static int delete_obj(int vnum);
  static void save_pk_log();
  static bool put_ingr_chest(CharData *ch, ObjData *obj, ObjData *chest);
  static bool take_ingr_chest(CharData *ch, ObjData *obj, ObjData *chest);

  bool is_clan_member(int unique);// true     unique  
  bool is_alli_member(int unique);// true     unique  

  void Manage(DescriptorData *d, const char *arg);
  void AddTopExp(CharData *ch, int add_exp);

  const char *GetAbbrev() { return this->abbrev.c_str(); };
  int get_chest_room();
  int GetRent();
  int GetOutRent();
  void SetClanExp(CharData *ch, int add);
  int GetClanLevel() { return this->clan_level; }
  std::string GetClanTitle() { return this->title; }
  std::string get_abbrev() const { return abbrev; }
  std::string get_file_abbrev() const;
  bool CheckPrivilege(int rank, int privilege) { return this->privileges[rank][privilege]; }
  int CheckPolitics(int victim);

  void add_remember(std::string text, int flag);
  std::string get_remember(unsigned int num, int flag) const;

  void write_mod(const std::string &arg);
  bool print_mod(CharData *ch) const;
  void load_mod();
  int get_rep();
  void set_rep(int rep);
  void init_ingr_chest();
  int get_ingr_chest_room_rnum() const { return ingr_chest_room_rnum_; };
  void set_ingr_chest_room_rnum(const int new_rnum) { ingr_chest_room_rnum_ = new_rnum; };
  int ingr_chest_tax();
  void purge_ingr_chest();
  int get_ingr_chest_objcount() const { return ingr_chest_objcount_; };
  bool ingr_chest_active() const;
  void set_ingr_chest(CharData *ch);
  void disable_ingr_chest(CharData *ch);
  int calculate_clan_tax() const;
  void add_offline_member(const std::string &name, int uid, int rank);
  int ingr_chest_max_objects();

  void save_chest();

  std::string get_web_url() const { return web_url_; };

  void set_bank(long num);
  long get_bank() const;

  void set_gold_tax_pct(long num);
  long get_gold_tax_pct() const;

  friend void ClanSystem::DoHouse(CharData *ch, char *argument, int cmd, int subcmd);
  friend void ClanSystem::DoClanChannel(CharData *ch, char *argument, int cmd, int subcmd);
  friend void ClanSystem::DoClanList(CharData *ch, char *argument, int cmd, int subcmd);
  friend void ClanSystem::DoShowPolitics(CharData *ch, char *argument, int cmd, int subcmd);
  friend void ClanSystem::DoHcontrol(CharData *ch, char *argument, int cmd, int subcmd);
  friend void ClanSystem::DoWhoClan(CharData *ch, char *argument, int cmd, int subcmd);
  friend void ClanSystem::DoClanPkList(CharData *ch, char *argument, int cmd, int subcmd);
  friend void ClanSystem::DoStoreHouse(CharData *ch, char *argument, int cmd, int subcmd);
  friend void ClanSystem::do_clanstuff(CharData *ch, char *argument, int cmd, int subcmd);
  friend void ClanSystem::DoShowWars(CharData *ch, char *argument, int cmd, int subcmd);
  friend void ClanSystem::do_show_alliance(CharData *ch, char *argument, int cmd, int subcmd);
  bool check_write_board(CharData *ch);
  int out_rent;   //    ,      

  //  
  ClanPkLog pk_log;
  //     
  ClanExp last_exp;
  //      
  ClanExpHistory exp_history;
  //  -
  ClanChestLog chest_log;

  static void SetPk(CharData *ch, std::string buffer);
  bool is_pk();
  void change_pk_status();

 private:
  std::string abbrev; //  ,  
  std::string name;   //   
  std::string title;  //        ( .,    )
  std::string title_female; // title    
  std::string owner;  //  
  MobVnum guard;     //  
  time_t builtOn;     //  
  double bankBuffer;  //       
  bool entranceMode;  //     /   
  std::vector<std::string> ranks; //   
  std::vector<std::string> ranks_female; //      
  ClanPolitics politics;     //  
  ClanPkList pkList;  // 
  ClanPkList frList;  // 
  long bank;          //   
  long long exp; //  -
  long long clan_exp; // -
  long
	  exp_buf;  //    -      - (exp_info),    6 
  int clan_level; //   
  int rent;       //     ,   
  bool pk;        //      
  int chest_room; //   ,    .       
  ClanPrivileges privileges; //    
  ClanMembersList m_members;    //    (, ,  )
  ClanStuffList clanstuff;   // -
  bool storehouse;    //       
  bool exp_info;      //     
  bool test_clan;     //   ( )
  std::string mod_text; //  
  //  ,      (-1   )
  int ingr_chest_room_rnum_;
  //     ' '
  std::string web_url_;
  //        
  long gold_tax_pct_;
  //  
  int reputation;
  //no save
  int chest_objcount;
  int chest_discount;
  int chest_weight;
  Remember::RememberListType remember_; //  
  Remember::RememberListType remember_ally_; //  
  int ingr_chest_objcount_;

  void SetPolitics(int victim, int state);
  void ManagePolitics(CharData *ch, std::string &buffer);
  void HouseInfo(CharData *ch);
  void HouseAdd(CharData *ch, std::string &buffer);
  void HouseRemove(CharData *ch, std::string &buffer);
  void ClanAddMember(CharData *ch, int rank, std::string invite_name);
  void HouseOwner(CharData *ch, std::string &buffer);
  void HouseLeave(CharData *ch);
  void HouseStat(CharData *ch, std::string &buffer);
  void remove_member(const ClanMembersList::key_type &it, char *reason);
  void save_clan_file(const std::string &filename) const;
  void house_web_url(CharData *ch, const std::string &buffer);

  // house  
  void MainMenu(DescriptorData *d);
  void PrivilegeMenu(DescriptorData *d, unsigned num);
  void AllMenu(DescriptorData *d, unsigned flag);
  void GodToChannel(CharData *ch, std::string text, int subcmd);
  void CharToChannel(CharData *ch, std::string text, int subcmd);

  static void HcontrolBuild(CharData *ch, std::string &buffer);
  static void HcontrolDestroy(CharData *ch, std::string &buffer);
  static void DestroyClan(Clan::shared_ptr clan, char *reason);
  static void fix_clan_members_load_room(Clan::shared_ptr clan);
  static void hcontrol_title(CharData *ch, std::string &text);
  static void hcontrol_rank(CharData *ch, std::string &text);
  static void hcontrol_exphistory(CharData *ch, std::string &text);
  static void hcontrol_set_ingr_chest(CharData *ch, std::string &text);
  static void hcon_outcast(CharData *ch, std::string &buffer);
  static void hcon_owner(CharData *ch, std::string &text);

  static void ChestLoad();
  int ChestTax();
  int ChestMaxObjects() {
	return (this->clan_level + 1) * 500 + 100;
  };
  int ChestMaxWeight() {
	return (this->clan_level + 1) * 5000 + 500;
  };
};

struct ClanOLC {
  int mode;                  //    
  Clan::shared_ptr clan;              // ,  
  ClanPrivileges privileges; //         
  int rank;                  //     
  std::bitset<ClanSystem::CLAN_PRIVILEGES_NUM> all_ranks; //   /  
};

struct ClanInvite {
  Clan::shared_ptr clan; //  
  int rank;     //   
  std::string invite_name; //   
};

void SetChestMode(CharData *ch, std::string &buffer);
std::string GetChestMode(CharData *ch);
std::string clan_get_custom_label(ObjData *obj, Clan::shared_ptr clan);

bool CHECK_CUSTOM_LABEL_CORE(const ObjData *obj, const CharData *ch);

//  arg       
//       
bool CHECK_CUSTOM_LABEL(const char *arg, const ObjData *obj, const CharData *ch);

inline bool CHECK_CUSTOM_LABEL(const std::string &arg, const ObjData *obj, const CharData *ch) {
  return CHECK_CUSTOM_LABEL(arg.c_str(), obj, ch);
}

bool is_alliance_by_abbr(const CharData *ch, char *abbrev);
//   ch  obj
bool AUTH_CUSTOM_LABEL(const ObjData *obj, const CharData *ch);

#endif // HOUSE_H_

// vim: ts=4 sw=4 tw=0 noet syntax=cpp :
