/**
\file do_wizlock.cpp - a part of the Bylins engine.
\authors Created by Sventovit.
\date 27.10.2025.
\brief Brief description.
\detail Detail description.
*/

#include "engine/entities/char_data.h"

extern int circle_restrict;

void DoWizlock(CharData *ch, char *argument, int/* cmd*/, int/* subcmd*/) {
	int value;
	const char *when;

	one_argument(argument, arg);
	if (*arg) {
		value = atoi(arg);
		if (value > kLvlImplementator)
			value = kLvlImplementator; // 34     
		if (value < 0 || (value > GetRealLevel(ch) && !ch->IsFlagged(EPrf::kCoderinfo))) {
			SendMsgToChar("   wizlock.\r\n", ch);
			return;
		}
		circle_restrict = value;
		when = "";
	} else
		when = "  ";

	switch (circle_restrict) {
		case 0: sprintf(buf, " %s  .\r\n", when);
			break;
		case 1: sprintf(buf, " %s    .\r\n", when);
			break;
		default:
			sprintf(buf, "  %d %s    %s   .\r\n",
					circle_restrict, GetDeclensionInNumber(circle_restrict, EWhat::kLvl), when);
			break;
	}
	SendMsgToChar(buf, ch);
}

// vim: ts=4 sw=4 tw=0 noet syntax=cpp :
