/**
\file do_spellstat.cpp - a part of the Bylins engine.
\authors Created by Sventovit.
\date 27.10.2025.
\brief Brief description.
\detail Detail description.
*/

#include "engine/entities/char_data.h"
#include "gameplay/statistics/spell_usage.h"
#include "engine/ui/modify.h"

void DoPageSpellStat(CharData *ch, char *argument, int/* cmd*/, int/* subcmd*/) {
	skip_spaces(&argument);

	if (!*argument) {
		SendMsgToChar(" [||||]\r\n", ch);
		return;
	}

	if (!str_cmp(argument, "")) {
		SpellUsage::is_active = true;
		SpellUsage::start = time(nullptr);
		SendMsgToChar(" .\r\n", ch);
		return;
	}

	if (!SpellUsage::is_active) {
		SendMsgToChar(" .   ' '.\r\n", ch);
		return;
	}

	if (!str_cmp(argument, "")) {
		SpellUsage::Clear();
		SpellUsage::is_active = false;
		SendMsgToChar(" .\r\n", ch);
		return;
	}

	if (!str_cmp(argument, "")) {
		page_string(ch->desc, SpellUsage::StatToPrint());
		return;
	}

	if (!str_cmp(argument, "")) {
		SpellUsage::Clear();
		return;
	}

	if (!str_cmp(argument, "")) {
		SpellUsage::Save();
		return;
	}

	SendMsgToChar(":  \r\n", ch);
}

// vim: ts=4 sw=4 tw=0 noet syntax=cpp :
