#include "engine/entities/char_data.h"
#include "engine/core/handler.h"

//      
void do_refill(CharData *ch, char *argument, int/* cmd*/, int/* subcmd*/) {
	char arg1[kMaxInputLength];
	char arg2[kMaxInputLength];
	ObjData *from_obj = nullptr, *to_obj = nullptr;

	argument = two_arguments(argument, arg1, arg2);

	if (!*arg1) {
		SendMsgToChar("  ?\r\n", ch);
		return;
	}
	if (!(from_obj = get_obj_in_list_vis(ch, arg1, ch->carrying))) {
		SendMsgToChar("   !\r\n", ch);
		return;
	}
	if (from_obj->get_type() != EObjType::kMagicArrow) {
		SendMsgToChar("     ?\r\n", ch);
		return;
	}
	if (GET_OBJ_VAL(from_obj, 1) == 0) {
		act(".", false, ch, from_obj, nullptr, kToChar);
		return;
	}
	if (!*arg2) {
		SendMsgToChar("    ?\r\n", ch);
		return;
	}
	if (!(to_obj = get_obj_in_list_vis(ch, arg2, ch->carrying))) {
		SendMsgToChar("    !\r\n", ch);
		return;
	}
	if (!((to_obj->get_type() == EObjType::kMagicContaner)
		|| to_obj->get_type() == EObjType::kMagicArrow)) {
		SendMsgToChar("      .\r\n", ch);
		return;
	}

	if (to_obj == from_obj) {
		SendMsgToChar(" ?      ?\r\n", ch);
		return;
	}

	if (GET_OBJ_VAL(to_obj, 2) >= GET_OBJ_VAL(to_obj, 1)) {
		SendMsgToChar("  .\r\n", ch);
		return;
	} else //   .  
	{
		if (GET_OBJ_VAL(from_obj, 0) != GET_OBJ_VAL(to_obj, 0)) {
			SendMsgToChar("      .\r\n", ch);
			return;
		}
		int t1 = GET_OBJ_VAL(from_obj, 3);  //  
		int t2 = GET_OBJ_VAL(to_obj, 3);
		int delta = (GET_OBJ_VAL(to_obj, 2) - GET_OBJ_VAL(to_obj, 3));
		if (delta >= t1) //   
		{
			to_obj->add_val(2, t1);
			SendMsgToChar("     .\r\n", ch);
			ExtractObjFromWorld(from_obj);
			return;
		} else {
			to_obj->add_val(2, (t2 - GET_OBJ_VAL(to_obj, 2)));
			SendMsgToChar("      .\r\n", ch);
			from_obj->add_val(2, (GET_OBJ_VAL(to_obj, 2) - t2));
			return;
		}
	}

	SendMsgToChar("      ,    .\r\n", ch);
}

// vim: ts=4 sw=4 tw=0 noet syntax=cpp :
