/**
\file peer.cpp - a part of the Bylins engine.
\authors Created by Sventovit.
\date 11.09.2024.
\brief description.
*/

#include "engine/entities/char_data.h"
#include "gameplay/mechanics/sight.h"
#include "engine/core/handler.h"

void DoPeer(CharData *ch, char * /*argument*/, int/* cmd*/, int/* subcmd*/) {
	int i;

	if (!ch->desc)
		return;

	if (ch->GetPosition() < EPosition::kSleep)
		SendMsgToChar("    ,   .\r\n", ch);
	if (ch->GetPosition() == EPosition::kSleep)
		SendMsgToChar("   ...\r\n", ch);
	else if (AFF_FLAGGED(ch, EAffect::kBlind))
		SendMsgToChar(" !\r\n", ch);
	else if (ch->GetSkill(ESkill::kLooking)) {
		if (check_moves(ch, kLookingMoves)) {
			SendMsgToChar("       .\r\n", ch);
			for (i = 0; i < EDirection::kMaxDirNum; i++)
				look_in_direction(ch, i, EXIT_SHOW_LOOKING);
			if (!(IS_IMMORTAL(ch) || GET_GOD_FLAG(ch, EGf::kGodsLike)))
				SetWaitState(ch, 1 * kBattleRound);
		}
	} else
		SendMsgToChar("     .\r\n", ch);
}

// vim: ts=4 sw=4 tw=0 noet syntax=cpp :
