/**
\file do_ignore.cpp - a part of the Bylins engine.
\authors Created by Sventovit.
\date 21.09.2024.
\brief Brief description.
\detail Detail description.
*/

#include "engine/entities/char_data.h"
#include "utils/utils_string.h"
#include "utils/utils.h"
#include "engine/core/comm.h"
#include "engine/ui/color.h"
#include "gameplay/communication/ignores.h"

void ignore_usage(CharData *ch);

void do_ignore(CharData *ch, char *argument, int/* cmd*/, int/* subcmd*/) {
	char arg1[kMaxInputLength];
	char arg2[kMaxInputLength];
	char arg3[kMaxInputLength];
	unsigned int mode = 0, list_empty = 1, all = 0, flag = 0;
	long vict_id;
	char buf[256], buf1[256], name[50];

	argument = one_argument(argument, arg1);
	argument = one_argument(argument, arg2);
	argument = one_argument(argument, arg3);

//   --  
	if (arg1[0] && (!arg2[0] || !arg3[0])) {
		ignore_usage(ch);
		return;
	}
//       
	if (!arg1[0] && !arg2[0] && !arg3[0]) {
		sprintf(buf, "%s   :%s\r\n", kColorWht, kColorNrm);
		SendMsgToChar(buf, ch);
		for (const auto &ignore : ch->get_ignores()) {
			if (!ignore->id)
				continue;
			if (ignore->id == -1) {
				strcpy(name, "");
			} else {
				strcpy(name, ign_find_name(ignore->id));
				name[0] = UPPER(name[0]);
			}
			sprintf(buf, "  %s: ", name);
			SendMsgToChar(buf, ch);
			mode = ignore->mode;
			SendMsgToChar(text_ignore_modes(mode, buf), ch);
			SendMsgToChar("\r\n", ch);
			list_empty = 0;
		}

		if (list_empty) {
			SendMsgToChar("   .\r\n", ch);
		}
		return;
	}

	if (utils::IsAbbr(arg2, ""))
		all = 1;
	else if (utils::IsAbbr(arg2, ""))
		flag = EIgnore::kTell;
	else if (utils::IsAbbr(arg2, ""))
		flag = EIgnore::kSay;
	else if (utils::IsAbbr(arg2, ""))
		flag = EIgnore::kWhisper;
	else if (utils::IsAbbr(arg2, ""))
		flag = EIgnore::kAsk;
	else if (utils::IsAbbr(arg2, ""))
		flag = EIgnore::kEmote;
	else if (utils::IsAbbr(arg2, ""))
		flag = EIgnore::kShout;
	else if (utils::IsAbbr(arg2, ""))
		flag = EIgnore::kGossip;
	else if (utils::IsAbbr(arg2, ""))
		flag = EIgnore::kHoller;
	else if (utils::IsAbbr(arg2, ""))
		flag = EIgnore::kGroup;
	else if (utils::IsAbbr(arg2, ""))
		flag = EIgnore::kClan;
	else if (utils::IsAbbr(arg2, ""))
		flag = EIgnore::kAlliance;
	else if (utils::IsAbbr(arg2, ""))
		flag = EIgnore::kOfftop;
	else {
		ignore_usage(ch);
		return;
	}

//  ""  id -1
	if (utils::IsAbbr(arg1, "")) {
		vict_id = -1;
	} else {
		// ,       
		//    ,     id
		switch (ign_find_id(arg1, &vict_id)) {
			case 0: SendMsgToChar("  ,   .\r\n", ch);
				return;
			case -1: SendMsgToChar("  ,  .\r\n", ch);
				return;
		}
	}

//    
	ignore_data::shared_ptr ignore = nullptr;
	for (const auto &ignore_i : ch->get_ignores()) {
		if (ignore_i->id == vict_id) {
			ignore = ignore_i;
			break;
		}
	}

	if (utils::IsAbbr(arg3, "")) {
//      ,   
		if (!ignore) {
			const auto cur = std::make_shared<ignore_data>();
			cur->id = vict_id;
			cur->mode = 0;
			ch->add_ignore(cur);
			ignore = cur;
		}
		mode = ignore->mode;
		if (all) {
			SET_BIT(mode, EIgnore::kTell);
			SET_BIT(mode, EIgnore::kSay);
			SET_BIT(mode, EIgnore::kWhisper);
			SET_BIT(mode, EIgnore::kAsk);
			SET_BIT(mode, EIgnore::kEmote);
			SET_BIT(mode, EIgnore::kShout);
			SET_BIT(mode, EIgnore::kGossip);
			SET_BIT(mode, EIgnore::kHoller);
			SET_BIT(mode, EIgnore::kGroup);
			SET_BIT(mode, EIgnore::kClan);
			SET_BIT(mode, EIgnore::kAlliance);
			SET_BIT(mode, EIgnore::kOfftop);
		} else {
			SET_BIT(mode, flag);
		}
		ignore->mode = mode;
	} else if (utils::IsAbbr(arg3, "")) {
		if (!ignore || ignore->id != vict_id) {
			if (vict_id == -1) {
				SendMsgToChar("      .\r\n", ch);
			} else {
				strcpy(name, ign_find_name(vict_id));
				name[0] = UPPER(name[0]);
				sprintf(buf,
						"     "
						" %s%s%s.\r\n", kColorWht, name, kColorNrm);
				SendMsgToChar(buf, ch);
			}
			return;
		}
		mode = ignore->mode;
		if (all) {
			mode = 0;
		} else {
			REMOVE_BIT(mode, flag);
		}
		ignore->mode = mode;
		if (!mode)
			ignore->id = 0;
	} else {
		ignore_usage(ch);
		return;
	}
	if (mode) {
		if (ignore->id == -1) {
			sprintf(buf, "    :%s.\r\n", text_ignore_modes(ignore->mode, buf1));
			SendMsgToChar(buf, ch);
		} else {
			strcpy(name, ign_find_name(ignore->id));
			name[0] = UPPER(name[0]);
			sprintf(buf, "  %s%s%s  :%s.\r\n",
					kColorWht, name, kColorNrm, text_ignore_modes(ignore->mode, buf1));
			SendMsgToChar(buf, ch);
		}
	} else {
		if (vict_id == -1) {
			SendMsgToChar("     .\r\n", ch);
		} else {
			strcpy(name, ign_find_name(vict_id));
			name[0] = UPPER(name[0]);
			sprintf(buf, "     %s%s%s.\r\n",
					kColorWht, name, kColorNrm);
			SendMsgToChar(buf, ch);
		}
	}
}

void ignore_usage(CharData *ch) {
	SendMsgToChar(" :  <|> <|> <|>\r\n"
				  " :\r\n"
				  "       \r\n"
				  "      \r\n", ch);
}

// vim: ts=4 sw=4 tw=0 noet syntax=cpp :
