#include "do_forget.h"

#include "gameplay/magic/spells_info.h"
#include "gameplay/mechanics/mem_queue.h"
#include "engine/core/handler.h"
#include "engine/ui/color.h"
#include "engine/db/global_objects.h"

inline bool in_mem(char *arg) {
	return (strlen(arg) != 0) &&
		(!strn_cmp("", arg, strlen(arg)) ||
			!strn_cmp("", arg, strlen(arg)) || !strn_cmp("book", arg, strlen(arg)));
}

void do_forget(CharData *ch, char *argument, int/* cmd*/, int/* subcmd*/) {
	char *s = nullptr, *t = nullptr;
	int is_in_mem;

	//    |
	one_argument(argument, arg);

	if (!*arg) {
		SendMsgToChar("   ?\r\n", ch);
		return;
	}

	size_t i = strlen(arg);
	if (!strn_cmp(arg, "recipe", i) || !strn_cmp(arg, "", i) ||
		!strn_cmp(arg, "", i)) {
		forget_recipe(ch, argument, 0);
		return;
	}

	if (!strn_cmp(arg, "", i) || !strn_cmp(arg, "all", i)) {
		char arg2[kMaxInputLength];
		two_arguments(argument, arg, arg2);
		if (in_mem(arg2)) {
			MemQ_flush(ch);
			SendMsgToChar("        .\r\n", ch);
		} else {
			for (auto spell_id = ESpell::kFirst ; spell_id <= ESpell::kLast; ++spell_id) {
				GET_SPELL_MEM(ch, spell_id) = 0;
			}
			sprintf(buf,
					"     %s.\r\n",
					GET_RELIGION(ch) == kReligionMono ? " " : " ");
			SendMsgToChar(buf, ch);
		}
		return;
	}
	if (IS_IMMORTAL(ch)) {
		SendMsgToChar(",    skillset?\r\n", ch);
		return;
	}
	if (!*argument) {
		SendMsgToChar("    ?\r\n", ch);
		return;
	}
	s = strtok(argument, "'*!");
	if (!str_cmp(s, argument)) {
		SendMsgToChar("       : *  !\r\n", ch);
		return;
	}
	auto spell_id = FixNameAndFindSpellId(s);
	if (spell_id == ESpell::kUndefined) {
		SendMsgToChar("     ?\r\n", ch);
		return;
	}
	if (!IS_SET(GET_SPELL_TYPE(ch, spell_id), ESpellType::kKnow | ESpellType::kTemp)) {
		SendMsgToChar("  ,   ...\r\n", ch);
		return;
	}
	t = strtok(nullptr, "\0");
	is_in_mem = 0;
	if (t != nullptr) {
		one_argument(t, arg);
		is_in_mem = in_mem(arg);
	}
	if (!is_in_mem)
		if (!GET_SPELL_MEM(ch, spell_id)) {
			SendMsgToChar("   - ,   - ...\r\n", ch);
			return;
		} else {
			--GET_SPELL_MEM(ch, spell_id);
			ch->caster_level -= MUD::Spell(spell_id).GetDanger();
			sprintf(buf, "   '%s%s%s'  %s.\r\n",
					kColorBoldCyn, MUD::Spell(spell_id).GetCName(),
					kColorNrm, GET_RELIGION(ch) == kReligionMono ? " " : " ");
			SendMsgToChar(buf, ch);
		}
	else
		MemQ_forget(ch, spell_id);
}
