#include "do_follow.h"

#include "gameplay/fight/fight.h"
#include "engine/core/handler.h"
#include "engine/db/global_objects.h"
#include "utils/backtrace.h"

void PerformDropGold(CharData *ch, int amount);

// Called when stop following persons, or stopping charm //
// This will NOT do if a character quits/dies!!          //
//   1  ch , ..   extract_char
// TODO:     ,   -  ,    -- Krodo
//     -    ,  ,    change_leader  
bool stop_follower(CharData *ch, int mode) {
	struct FollowerType *j, *k;
	int i;

	//log("[Stop ch] Start function(%s->%s)",ch ? GET_NAME(ch) : "none",
	//      ch->master ? GET_NAME(ch->master) : "none");

	if (!ch->has_master()) {
//		debug::backtrace(runtime_config.logs(ERRLOG).handle());
		log("SYSERR: stop_follower(%s) without master", GET_NAME(ch));
		return (false);
	}

	//      
	if (!IS_SET(mode, kSfSilence)) {
		act("    $N4.", false, ch, 0, ch->get_master(), kToChar);
		act("$n $g   $N4.", true, ch, 0, ch->get_master(), kToNotVict | kToArenaListen);
	}

	//log("[Stop ch] Stop horse");
	if (ch->get_master()->get_horse() == ch && ch->get_master()->IsOnHorse()) {
		ch->DropFromHorse();
	} else {
		act("$n $g   .", true, ch, 0, ch->get_master(), kToVict);
	}

	//log("[Stop ch] Remove from followers list");
	if (!ch->get_master()->followers) {
		log("[Stop ch] SYSERR: Followers absent for %s (master %s).", GET_NAME(ch), GET_NAME(ch->get_master()));
	} else if (ch->get_master()->followers->follower == ch)    // Head of ch-list?
	{
		k = ch->get_master()->followers;
		ch->get_master()->followers = k->next;
		if (!ch->get_master()->followers
			&& !ch->get_master()->has_master()) {
			//AFF_FLAGS(ch->get_master()).unset(EAffectFlag::AFF_GROUP);
			ch->get_master()->removeGroupFlags();
		}
		free(k);
	} else        // locate ch who is not head of list
	{
		for (k = ch->get_master()->followers; k->next && k->next->follower != ch; k = k->next);
		if (!k->next) {
			log("[Stop ch] SYSERR: Undefined %s in %s followers list.", GET_NAME(ch), GET_NAME(ch->get_master()));
		} else {
			j = k->next;
			k->next = j->next;
			free(j);
		}
	}

	ch->set_master(nullptr);
	//AFF_FLAGS(ch).unset(EAffectFlag::AFF_GROUP);
	ch->removeGroupFlags();

	if (AFF_FLAGGED(ch, EAffect::kCharmed)
		|| AFF_FLAGGED(ch, EAffect::kHelper)
		|| IS_SET(mode, kSfCharmlost)) {
		if (IsAffectedBySpell(ch, ESpell::kCharm)) {
			RemoveAffectFromChar(ch, ESpell::kCharm);
		}
		ch->extract_timer = 5;
		AFF_FLAGS(ch).unset(EAffect::kCharmed);

		if (ch->GetEnemy()) {
			stop_fighting(ch, true);
		}

		if (ch->IsNpc()) {
			if (ch->IsFlagged(EMobFlag::kCorpse)) {
				act("   $n3,    .", true, ch, 0, 0, kToRoom | kToArenaListen);
				GET_LASTROOM(ch) = ch->in_room;
				PerformDropGold(ch, ch->get_gold());
				ch->set_gold(0);
				if (!IS_SET(mode, kSfFollowerdie)) {
					ExtractCharFromWorld(ch, false);
				}
				return (true);
			} else if (AFF_FLAGGED(ch, EAffect::kHelper)) {
				AFF_FLAGS(ch).unset(EAffect::kHelper);
			}
		}
	}
	if (ch->IsNpc() && ch->IsFlagged(EMobFlag::kSummoned)) {
		act("  $n3 ,  $n0 $u  .", true, ch, 0, 0, kToRoom | kToArenaListen);
		ch->restore_npc();
			//   
				while (ch->carrying) {
						ObjData *obj = ch->carrying;
					RemoveObjFromChar(obj);
					PlaceObjToRoom(obj, ch->in_room);
					}
			
			for (int i = 0; i < EEquipPos::kNumEquipPos; i++) { //   
				if (GET_EQ(ch, i)) {
					if (!remove_otrigger(GET_EQ(ch, i), ch)) {
						continue;
					}
					PlaceObjToInventory(UnequipChar(ch, i, CharEquipFlag::show_msg), ch);
					//extract_obj(tmp);
					while (ch->carrying) {
						ObjData *obj = ch->carrying;
						ExtractObjFromWorld(obj);
					}
				}
			}
		
	}
	
	 
	if (ch->IsNpc() && (i = GET_MOB_RNUM(ch)) >= 0) {
		ch->CopyFlagsFrom(mob_proto + i);
	}

	return (false);
}

// * Called when a character that follows/is followed dies
bool die_follower(CharData *ch) {
	struct FollowerType *j, *k = ch->followers;

	if (ch->has_master() && stop_follower(ch, kSfFollowerdie)) {
		//     stop_follower
		return true;
	}

	if (ch->IsOnHorse()) {
		AFF_FLAGS(ch).unset(EAffect::kHorse);
	}

	for (k = ch->followers; k; k = j) {
		j = k->next;
		stop_follower(k->follower, kSfMasterdie);
	}
	return false;
}

// Check if making CH follow VICTIM will create an illegal //
// Follow "Loop/circle"                                    //
bool circle_follow(CharData *ch, CharData *victim) {
	for (auto k = victim; k; k = k->get_master()) {
		if (k->get_master() == k) {
			k->set_master(nullptr);
			return false;
		}
		if (k == ch) {
			return true;
		}
	}
	return false;
}

void do_follow(CharData *ch, char *argument, int/* cmd*/, int/* subcmd*/) {
	CharData *leader;
	struct FollowerType *f;
	one_argument(argument, smallBuf);

	if (ch->IsNpc() && AFF_FLAGGED(ch, EAffect::kCharmed) && ch->GetEnemy())
		return;
	if (*smallBuf) {
		if (!str_cmp(smallBuf, "") || !str_cmp(smallBuf, "self") || !str_cmp(smallBuf, "me")) {
			if (!ch->has_master()) {
				SendMsgToChar("       ...\r\n", ch);
			} else {
				stop_follower(ch, kSfEmpty);
			}
			return;
		}
		if (!(leader = get_char_vis(ch, smallBuf, EFind::kCharInRoom))) {
			SendMsgToChar(NOPERSON, ch);
			return;
		}
	} else {
		SendMsgToChar("    ?\r\n", ch);
		return;
	}

	if (ch->get_master() == leader) {
		act("    $N4.", false, ch, 0, leader, kToChar);
		return;
	}

	if (AFF_FLAGGED(ch, EAffect::kCharmed)
		&& ch->has_master()) {
		act("      $N4!", false, ch, 0, ch->get_master(), kToChar);
	} else        // Not Charmed follow person
	{
		if (leader == ch) {
			if (!ch->has_master()) {
				SendMsgToChar("    .\r\n", ch);
				return;
			}
			stop_follower(ch, kSfEmpty);
		} else {
			if (circle_follow(ch, leader)) {
				SendMsgToChar("     .\r\n", ch);
				return;
			}

			if (ch->has_master()) {
				stop_follower(ch, kSfEmpty);
			}
			//AFF_FLAGS(ch).unset(EAffectFlag::AFF_GROUP);
			ch->removeGroupFlags();
			for (f = ch->followers; f; f = f->next) {
				//AFF_FLAGS(f->ch).unset(EAffectFlag::AFF_GROUP);
				f->follower->removeGroupFlags();
			}

			leader->add_follower(ch);
		}
	}
}
