#include "do_create.h"

#include "gameplay/crafting/im.h"
#include "gameplay/magic/magic_utils.h"
#include "engine/core/handler.h"

void do_create(CharData *ch, char *argument, int/* cmd*/, int subcmd) {
	char *s;

	if (ch->IsNpc())
		return;

	// get: blank, spell name, target name
	argument = one_argument(argument, arg);
	skip_spaces(&argument);

	if (!*arg) {
		if (subcmd == SCMD_RECIPE)
			SendMsgToChar("    ?\r\n", ch);
		else
			SendMsgToChar("   ?\r\n", ch);
		return;
	}

	size_t i = strlen(arg);
	ESpellType itemnum;
	if (!strn_cmp(arg, "potion", i) || !strn_cmp(arg, "", i))
		itemnum = ESpellType::kPotionCast;
	else if (!strn_cmp(arg, "wand", i) || !strn_cmp(arg, "", i))
		itemnum = ESpellType::kWandCast;
	else if (!strn_cmp(arg, "scroll", i) || !strn_cmp(arg, "", i))
		itemnum = ESpellType::kScrollCast;
	else if (!strn_cmp(arg, "recipe", i) || !strn_cmp(arg, "", i) ||
		!strn_cmp(arg, "", i)) {
		if (subcmd != SCMD_RECIPE) {
			SendMsgToChar("   .\r\n", ch);
			return;
		}
//		itemnum = SPELL_ITEMS;
		compose_recipe(ch, argument, 0);
		return;
	} else if (!strn_cmp(arg, "runes", i) || !strn_cmp(arg, "", i)) {
		if (subcmd != SCMD_RECIPE) {
			SendMsgToChar("  .\r\n", ch);
			return;
		}
		itemnum = ESpellType::kRunes;
	} else {
		if (subcmd == SCMD_RECIPE)
			snprintf(buf, kMaxInputLength, " '%s'   .\r\n", arg);
		else
			snprintf(buf, kMaxInputLength, " '%s'    .\r\n", arg);
		SendMsgToChar(buf, ch);
		return;
	}
	if (!*argument) {
		sprintf(buf, "  !\r\n");
		SendMsgToChar(buf, ch);
		return;
	}
	s = strtok(argument, "'*!");
	if (!str_cmp(s, argument)) {
		SendMsgToChar("       : '  *  !\r\n", ch);
		return;
	}
	auto spell_id = FixNameAndFindSpellId(s);
	if (spell_id == ESpell::kUndefined) {
		SendMsgToChar("    ?\r\n", ch);
		return;
	}
	// Caster is don't know this recipe
	if (!IS_SET(GET_SPELL_TYPE(ch, spell_id), itemnum) && !IS_IMMORTAL(ch)) {
		SendMsgToChar("       .\r\n", ch);
		return;
	}
	if (subcmd == SCMD_RECIPE) {
		CheckRecipeValues(ch, spell_id, itemnum, true);
		return;
	}
	if (!CheckRecipeValues(ch, spell_id, itemnum, false)) {
		SendMsgToChar("     .\r\n", ch);
		return;
	}
	if (!CheckRecipeItems(ch, spell_id, itemnum, true)) {
		SendMsgToChar("    !\r\n", ch);
		return;
	}
}
