/**
\file consider.cpp - a part of the Bylins engine.
\authors Created by Sventovit.
\date 11.09.2024.
\brief description.
*/

#include "engine/entities/char_data.h"
#include "engine/core/handler.h"

void DoConsider(CharData *ch, char *argument, int/* cmd*/, int/* subcmd*/) {
	CharData *victim;
	int diff;

	one_argument(argument, buf);

	if (!(victim = get_char_vis(ch, buf, EFind::kCharInRoom))) {
		SendMsgToChar("   ?\r\n", ch);
		return;
	}
	if (victim == ch) {
		SendMsgToChar("!   < >!\r\n", ch);
		return;
	}
	if (!victim->IsNpc()) {
		SendMsgToChar("   -    .\r\n", ch);
		return;
	}
	diff = (GetRealLevel(victim) - GetRealLevel(ch) - GetRealRemort(ch));

	if (diff <= -10)
		SendMsgToChar("-,  .\r\n", ch);
	else if (diff <= -5)
		SendMsgToChar("\"    !\"\r\n", ch);
	else if (diff <= -2)
		SendMsgToChar(".\r\n", ch);
	else if (diff <= -1)
		SendMsgToChar(" .\r\n", ch);
	else if (diff == 0)
		SendMsgToChar(" !\r\n", ch);
	else if (diff <= 1)
		SendMsgToChar("   !\r\n", ch);
	else if (diff <= 2)
		SendMsgToChar("  !\r\n", ch);
	else if (diff <= 3)
		SendMsgToChar("      !\r\n", ch);
	else if (diff <= 5)
		SendMsgToChar("     .\r\n", ch);
	else if (diff <= 10)
		SendMsgToChar(",   .\r\n", ch);
	else if (diff <= 100)
		SendMsgToChar("   -    !\r\n", ch);

}

// vim: ts=4 sw=4 tw=0 noet syntax=cpp :
