/**
\file do_antigods.cpp - a part of the Bylins engine.
\authors Created by Sventovit.
\date 19.09.2024.
\brief Brief description.
\detail Detail description.
*/

#include "engine/entities/char_data.h"

void do_antigods(CharData *ch, char * /*argument*/, int/* cmd*/, int/* subcmd*/) {
	if (IS_IMMORTAL(ch)) {
		SendMsgToChar("  ?\r\n", ch);
		return;
	}
	if (AFF_FLAGGED(ch, EAffect::kGodsShield)) {
		if (IsAffectedBySpell(ch, ESpell::kGodsShield)) {
			RemoveAffectFromChar(ch, ESpell::kGodsShield);
		}
		AFF_FLAGS(ch).unset(EAffect::kGodsShield);
		SendMsgToChar("     .\r\n", ch);
		act("&W$n $g ,  .&n", true, ch, nullptr, nullptr, kToRoom | kToArenaListen);
	} else {
		SendMsgToChar("      .\r\n", ch);
	}
}

// vim: ts=4 sw=4 tw=0 noet syntax=cpp :
